/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.FIWSystem;
import fiw.core.GUIHelper;
import fiw.core.I18n;
import fiw.gui.awt.Wizard;
import fiw.gui.awt.WizardPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SelectWP
extends WizardPanel
implements ActionListener {
    Checkbox newProject;
    Checkbox editProject;
    Checkbox uploadProject;
    Checkbox deleteProject;
    Checkbox uploadFile;
    Checkbox checkNIMs;
    List projects;

    public SelectWP(Wizard w) {
        super(w);
        CheckboxGroup cg = new CheckboxGroup();
        this.newProject = new Checkbox(I18n.get("SelectNew"), cg, false);
        this.add((Component)this.newProject, gbcRight);
        this.editProject = new Checkbox(I18n.get("SelectEdit"), cg, false);
        this.add((Component)this.editProject, gbcRight);
        this.deleteProject = new Checkbox(I18n.get("SelectDelete"), cg, false);
        this.add((Component)this.deleteProject, gbcRight);
        this.uploadProject = new Checkbox(I18n.get("SelectUpload"), cg, true);
        this.add((Component)this.uploadProject, gbcRight);
        this.add((Component)new Panel(), gbcRight);
        this.uploadFile = new Checkbox(I18n.get("SelectUploadNIM"), cg, false);
        this.add((Component)this.uploadFile, gbcRight);
        this.checkNIMs = new Checkbox(I18n.get("SelectCheckNIM"), cg, false);
        this.add((Component)this.checkNIMs, gbcRight);
        this.add((Component)new Panel(), gbcRight);
        Panel p = new Panel(new GridLayout(2, 1));
        this.add((Component)p, gbcRight);
        Button b = new Button(I18n.get("Open_LoadStatus"));
        p.add(b);
        b.setActionCommand("LoadStatus");
        b.addActionListener(this);
        b = new Button(I18n.get("Open_MetaDataBrowser"));
        p.add(b);
        b.setActionCommand("MetaDataBrowser");
        b.addActionListener(this);
        this.add((Component)new Panel(), gbcRight);
        p = new Panel(new GridLayout(1, 3));
        this.add((Component)p, gbcRight);
        b = new Button(I18n.get("ProjectMoveUp"));
        p.add(b);
        b.setActionCommand("Up");
        b.addActionListener(this);
        b = new Button(I18n.get("ProjectClone"));
        p.add(b);
        b.setActionCommand("Clone");
        b.addActionListener(this);
        b = new Button(I18n.get("ProjectMoveDown"));
        p.add(b);
        b.setActionCommand("Down");
        b.addActionListener(this);
        this.projects = new List();
        this.add((Component)this.projects, gbcBottom);
    }

    public void refresh() {
        int selected = this.projects.getSelectedIndex();
        this.projects.removeAll();
        String[] pr = FIWSystem.setts().getProjectNames();
        for (int i = 0; i < pr.length; ++i) {
            this.projects.add("[" + (i + 1) + "] " + pr[i]);
        }
        if (selected >= 0 && selected < pr.length) {
            this.projects.select(selected);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        int projectnum = this.projects.getSelectedIndex();
        String cmd = evt.getActionCommand();
        GUIHelper gh = GUIHelper.getInstance();
        if ("LoadStatus".equals(cmd)) {
            gh.openLoadStatus();
        } else if ("MetaDataBrowser".equals(cmd)) {
            gh.openMetadataBrowser();
        } else if (projectnum != -1) {
            if ("Up".equals(cmd)) {
                if (gh.moveProjectUp(projectnum)) {
                    this.refresh();
                    this.projects.select(projectnum - 1);
                }
            } else if ("Down".equals(cmd)) {
                if (gh.moveProjectDown(projectnum)) {
                    this.refresh();
                    this.projects.select(projectnum + 1);
                }
            } else if ("Clone".equals(cmd)) {
                int newnum = gh.cloneProject(projectnum);
                this.refresh();
                this.projects.select(newnum);
            }
        }
    }

    public int getNext() {
        if (this.newProject.getState()) {
            this.parent.setProjectNumber(FIWSystem.setts().getProjCount());
            return 3;
        }
        if (this.checkNIMs.getState()) {
            return 10;
        }
        if (this.projects.getSelectedIndex() == -1) {
            return 2;
        }
        this.parent.setProjectNumber(this.projects.getSelectedIndex());
        if (this.uploadFile.getState()) {
            return 9;
        }
        if (this.editProject.getState()) {
            return 3;
        }
        if (this.uploadProject.getState()) {
            return 8;
        }
        if (this.deleteProject.getState()) {
            return 7;
        }
        return 1;
    }

    public int getPrev() {
        if (this.parent.isAdvancedOpen()) {
            return 1;
        }
        return 0;
    }
}

