/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.I18n;
import fiw.gui.awt.ProjectOptionWizardPanel;
import fiw.gui.awt.Wizard;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextArea;
import java.io.File;

public class ParserSettingsWP
extends ProjectOptionWizardPanel {
    Checkbox parse = new Checkbox(I18n.get("ParseIndex"), false);
    TextArea files;

    public ParserSettingsWP(Wizard w) {
        super(5, w);
        this.add((Component)this.parse, gbcRight);
        this.add((Component)new Label(I18n.get("ParseAdditional")), gbcRight);
        this.files = new TextArea("", 10, 10, 1);
        this.add((Component)this.files, gbcBottom);
    }

    public void refresh() {
        if (this.norefresh) {
            this.norefresh = false;
            return;
        }
        super.refresh();
        String toparse = FileUtil.loadFile(this.parseFile());
        if (toparse.startsWith("index.html\n")) {
            this.parse.setState(true);
            toparse = toparse.substring(11);
        } else {
            this.parse.setState(false);
        }
        this.files.setText(toparse);
        this.files.setEditable(this.parseDir().isDirectory());
        this.parse.setEnabled(this.parseDir().isDirectory());
    }

    private void saveSettings() {
        if (!this.save()) {
            throw new RuntimeException("Cannot be!");
        }
        String toparse = (this.parse.getState() ? "index.html\n" : "") + this.files.getText();
        if (toparse.length() != 0 && !toparse.equals("\n")) {
            FileUtil.saveFile(this.parseFile(), toparse);
        } else {
            this.parseFile().delete();
        }
    }

    public int getNext() {
        this.saveSettings();
        return 6;
    }

    public int getPrev() {
        if (this.isDBR()) {
            return 4;
        }
        return 3;
    }

    public File parseDir() {
        return FileUtil.fiwDir(FIWSystem.setts().getProjectFile(this.parent.getProjectNumber()));
    }

    public File parseFile() {
        return new File(this.parseDir(), "parse.ini");
    }
}

