/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.option.AbstractOptions;
import fiw.core.option.BooleanOptionType;
import fiw.core.option.ButtonOption;
import fiw.core.option.ChoiceOptionType;
import fiw.core.option.DBRSlotOptionType;
import fiw.core.option.DayTimeOptionType;
import fiw.core.option.Option;
import fiw.core.option.OptionType;
import fiw.core.option.TimestampOptionType;
import fiw.gui.awt.ButtonOptionActionListener;
import fiw.gui.awt.ChoicePanel;
import fiw.gui.awt.DBRSlotPanel;
import fiw.gui.awt.DayTimePanel;
import fiw.gui.awt.TimestampPanel;
import fiw.gui.awt.Wizard;
import fiw.gui.awt.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;

public abstract class OptionBasedWizardPanel
extends WizardPanel {
    private int panelNumber;
    protected boolean norefresh;
    protected Component[] settings;
    protected TextArea errors = null;
    private AbstractOptions opts;

    protected AbstractOptions getOptionsList() {
        return this.opts;
    }

    public OptionBasedWizardPanel(int panelNumber, AbstractOptions opts, Wizard w) {
        super(w);
        this.panelNumber = panelNumber;
        this.opts = opts;
    }

    protected void layoutOptions() {
        DBRSlotPanel lastDBR = null;
        Option[] sets = this.opts.getSettings();
        this.settings = new Component[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            Option o = sets[i];
            if (o.getPanelNumber() != this.panelNumber) continue;
            if (o.isSpecial()) {
                if (o instanceof ButtonOption) {
                    Button b = new Button(o.getName());
                    this.add((Component)b, gbcRight);
                    b.addActionListener(new ButtonOptionActionListener((ButtonOption)o, this));
                    this.settings[i] = b;
                    continue;
                }
                this.settings[i] = this.layoutSpecials(o);
                continue;
            }
            OptionType t = o.getType();
            if (t instanceof BooleanOptionType) {
                this.settings[i] = new Checkbox(o.getName(), false);
                this.add(this.settings[i], gbcRight);
                continue;
            }
            if (t instanceof ChoiceOptionType) {
                this.settings[i] = new ChoicePanel((ChoiceOptionType)t);
                this.add(this.settings[i], gbcRight);
                continue;
            }
            if (t instanceof DBRSlotOptionType) {
                this.add((Component)new Label(o.getName() + ":"), gbcLeft);
                this.settings[i] = new DBRSlotPanel((DBRSlotOptionType)t, lastDBR);
                this.add(this.settings[i], gbcRight);
                if (lastDBR != null) {
                    lastDBR.setFollowing((DBRSlotPanel)this.settings[i]);
                }
                lastDBR = (DBRSlotPanel)this.settings[i];
                continue;
            }
            if (t instanceof DayTimeOptionType) {
                this.settings[i] = new DayTimePanel(this, o.getName() + ":");
                continue;
            }
            if (t instanceof TimestampOptionType) {
                this.settings[i] = new TimestampPanel(this, o.getName() + ":");
                continue;
            }
            this.add((Component)new Label(o.getName() + ":"), gbcLeft);
            if (sets.length > i + 1 && sets[i + 1].getPanelNumber() == this.panelNumber && sets[i + 1] instanceof ButtonOption && ((ButtonOption)sets[i + 1]).isGroupedWithPrevious()) {
                Panel p = new Panel(new BorderLayout());
                this.add((Component)p, gbcRight);
                this.settings[i] = new TextField("");
                p.add("Center", this.settings[i]);
                o = sets[++i];
                Button b = new Button(o.getName());
                p.add("East", b);
                b.addActionListener(new ButtonOptionActionListener((ButtonOption)o, this));
                this.settings[i] = b;
                continue;
            }
            this.settings[i] = new TextField("");
            this.add(this.settings[i], gbcRight);
        }
    }

    public void refresh() {
        if (this.norefresh) {
            this.norefresh = false;
            return;
        }
        Option[] sets = this.loadOptions();
        for (int i = 0; i < sets.length; ++i) {
            this.refreshOption(i, sets);
        }
        if (this.errors != null) {
            this.errors.setText("");
        }
    }

    public void refreshOption(int no, Option[] sets) {
        Option o = sets[no];
        if (o.getPanelNumber() == this.panelNumber && o instanceof ButtonOption) {
            ((Button)this.settings[no]).setEnabled(o.isEnabled());
        }
        if (o.getPanelNumber() == this.panelNumber && !o.isSpecial()) {
            OptionType t = o.getType();
            if (t instanceof BooleanOptionType) {
                ((Checkbox)this.settings[no]).setState("true".equals(o.getValue()));
                ((Checkbox)this.settings[no]).setEnabled(o.isEnabled());
            } else if (t instanceof ChoiceOptionType) {
                ((ChoicePanel)this.settings[no]).setState(o.getValue());
                ((ChoicePanel)this.settings[no]).setEditable(o.isEnabled());
            } else if (t instanceof DBRSlotOptionType) {
                ((DBRSlotPanel)this.settings[no]).setValue("");
                ((DBRSlotPanel)this.settings[no]).setEditable(o.isEnabled());
            } else if (t instanceof DayTimeOptionType) {
                ((DayTimePanel)this.settings[no]).setValue(o.getValue());
            } else if (t instanceof TimestampOptionType) {
                ((TimestampPanel)this.settings[no]).setValue(o.getValue());
            } else {
                ((TextField)this.settings[no]).setText(o.getValue());
                ((TextField)this.settings[no]).setEditable(o.isEnabled());
            }
        }
    }

    protected boolean save() {
        Option[] sets = this.opts.getSettings();
        for (int i = 0; i < sets.length; ++i) {
            if (this.flushOption(i, sets)) continue;
            this.norefresh = true;
            return false;
        }
        this.opts.save();
        return true;
    }

    protected boolean flushOption(int no, Option[] sets) {
        Option o = sets[no];
        if (o.getPanelNumber() == this.panelNumber && !o.isSpecial()) {
            OptionType t = o.getType();
            String value = t instanceof BooleanOptionType ? (((Checkbox)this.settings[no]).getState() ? "true" : "false") : (t instanceof ChoiceOptionType ? ((ChoicePanel)this.settings[no]).getState() : (t instanceof DBRSlotOptionType ? ((DBRSlotPanel)this.settings[no]).getValue() : (t instanceof DayTimeOptionType ? ((DayTimePanel)this.settings[no]).getValue() : (t instanceof TimestampOptionType ? ((TimestampPanel)this.settings[no]).getValue() : ((TextField)this.settings[no]).getText()))));
            if (o.isEnabled() && !o.setValue(value)) {
                if (this.errors != null) {
                    this.errors.setText(o.getName() + ": " + o.getInvalidReason(value));
                } else {
                    System.err.println(o.getName() + ": " + o.getInvalidReason(value));
                }
                return false;
            }
        }
        return true;
    }

    protected abstract Component layoutSpecials(Option var1);

    protected final Option[] loadOptions() {
        this.opts.load();
        return this.opts.getSettings();
    }

    protected final void saveOptions() {
        this.opts.save();
    }
}

