/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.GUIHelper;
import fiw.core.I18n;
import fiw.core.insert.event.InsertLoggerListener;
import fiw.gui.awt.InsertDialog;
import fiw.gui.awt.Wizard;
import fiw.gui.awt.WizardPanel;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;

public class NimInsertWP
extends WizardPanel {
    private Checkbox name;
    private Checkbox contents;
    private Checkbox redirect;
    private Checkbox rawmetadata;
    private Checkbox advance;
    private TextArea desc;
    private TextField key;
    private TextField htl;
    private TextField ctype;
    private boolean norefresh = false;

    public NimInsertWP(Wizard w) {
        super(w);
        this.add((Component)new Label(I18n.get("NIM_Key")), gbcLeft);
        this.key = new TextField();
        this.add((Component)this.key, gbcRight);
        this.advance = new Checkbox(I18n.get("AutoAdvance"));
        this.add((Component)this.advance, gbcRight);
        this.add((Component)new Label(I18n.get("NIM_HTL")), gbcLeft);
        this.htl = new TextField("15");
        this.add((Component)this.htl, gbcRight);
        this.add((Component)new Label(I18n.get("NIM_CType")), gbcLeft);
        this.ctype = new TextField("text/plain");
        this.add((Component)this.ctype, gbcRight);
        CheckboxGroup cg = new CheckboxGroup();
        this.name = new Checkbox(I18n.get("NIM_Filename"), cg, false);
        this.add((Component)this.name, gbcRight);
        this.contents = new Checkbox(I18n.get("NIM_Contents"), cg, true);
        this.add((Component)this.contents, gbcRight);
        this.redirect = new Checkbox(I18n.get("NIM_Redirect"), cg, false);
        this.add((Component)this.redirect, gbcRight);
        this.rawmetadata = new Checkbox(I18n.get("NIM_Raw"), cg, false);
        this.add((Component)this.rawmetadata, gbcRight);
        this.desc = new TextArea("", 10, 10, 1);
        this.add((Component)this.desc, gbcBottom);
    }

    public int getNext() {
        if (this.send()) {
            return 2;
        }
        this.norefresh = true;
        return 9;
    }

    public int getPrev() {
        return 2;
    }

    public void refresh() {
        if (this.norefresh) {
            this.norefresh = false;
            return;
        }
        int projectnum = this.parent.getProjectNumber();
        this.key.setText(GUIHelper.getInstance().getDefaultNIM(projectnum));
    }

    private boolean send() {
        int htlvalue;
        try {
            htlvalue = Integer.parseInt(this.htl.getText());
        }
        catch (NumberFormatException e) {
            return false;
        }
        boolean adv = this.advance.getState();
        InsertDialog dialog = new InsertDialog(false);
        boolean res = GUIHelper.getInstance().handleNIMInsert(this.desc.getText(), htlvalue, adv, this.key.getText(), this.contents.getState(), this.name.getState(), this.redirect.getState(), this.rawmetadata.getState(), this.ctype.getText(), new InsertLoggerListener(dialog));
        if (!res) {
            dialog.dispose();
        }
        return res;
    }
}

