/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.FIWSystem;
import fiw.core.I18n;
import fiw.core.Stoppable;
import fiw.core.insert.InsertContext;
import fiw.core.insert.InsertLogger;
import fiw.gui.awt.Wizard;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;

public class InsertDialog
extends Frame
implements InsertLogger {
    Stoppable myEngine;
    TextArea result;
    TextArea status;
    TextArea status2;
    String[] threadstat;
    int[] threadnum;
    int[] globalnumber;
    List actions = new Vector();
    List actnumbers = new Vector();
    int maxnum = 0;
    boolean autoclose = false;
    boolean isstopping = false;

    public InsertDialog(boolean twopart) {
        this(twopart, false);
    }

    public InsertDialog(boolean twopart, boolean autoclose) {
        super(I18n.get("Insertion_in_progress"));
        this.autoclose = autoclose;
        Font font = new Font("Monospaced", 0, 12);
        this.result = new TextArea("", twopart ? 15 : 30, 80, 1);
        this.add("Center", this.result);
        this.result.setEditable(false);
        this.result.setFont(font);
        this.setIconImage(Wizard.fiwIcon);
        if (twopart) {
            int threads = Integer.parseInt(FIWSystem.setts().getProperty("tuning.threadcount"));
            this.threadnum = new int[threads];
            this.globalnumber = new int[threads];
            this.threadstat = new String[threads];
            Panel p = new Panel(new GridLayout(1, 2));
            this.add("South", p);
            this.status = new TextArea("", 15, 40);
            p.add(this.status);
            this.status.setEditable(false);
            this.status.setFont(font);
            this.status2 = new TextArea("", 15, 40);
            p.add(this.status2);
            this.status2.setEditable(false);
            this.status2.setFont(font);
        } else {
            this.threadstat = new String[0];
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (InsertDialog.this.myEngine != null) {
                    InsertDialog.this.myEngine.stopRunning();
                    InsertDialog.this.myEngine = null;
                    InsertDialog.this.isstopping = true;
                } else {
                    InsertDialog.this.isstopping = false;
                    InsertDialog.this.dispose();
                }
            }
        });
        Point pt = this.getLocation();
        this.setLocation(pt.x + 50, pt.y + 50);
        this.pack();
        this.show();
    }

    public synchronized void addlog(String s) {
        this.addlogNoNewline(s + "\n");
    }

    public synchronized void addlogNoNewline(String s) {
        try {
            this.result.append(s);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.result.setText(I18n.get("LogTruncated") + "\n" + s);
        }
    }

    public synchronized void setStatus(String s) {
        this.setTitle(s);
    }

    public synchronized int addThread(int globalno) {
        if (this.threadstat.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.threadstat.length; ++i) {
            if (this.threadstat[i] != null) continue;
            this.threadstat[i] = I18n.get("ThreadStarting");
            this.threadnum[i] = ++this.maxnum;
            this.globalnumber[i] = globalno;
            this.actions.add(I18n.get("ActionStarting"));
            this.actnumbers.add(new Integer(globalno));
            this.refreshview();
            return i + 1;
        }
        this.addlog("** Thread timing error! **");
        return -1;
    }

    private void refreshview() {
        int j;
        int i;
        StringBuffer sb = new StringBuffer(I18n.get("CurrActHeader"));
        for (i = 0; i < this.threadstat.length; ++i) {
            if (this.threadstat[i] == null) {
                sb.append('\n');
                continue;
            }
            j = this.globalnumber[i];
            sb.append(j < 10 ? "#0" : "#").append(j).append(": ").append(this.threadstat[i]).append('\n');
        }
        this.status.setText(sb.toString());
        sb.setLength(0);
        sb.append(I18n.get("AllActHeader"));
        for (i = 0; i < this.actions.size(); ++i) {
            j = (Integer)this.actnumbers.get(i);
            sb.append(j < 10 ? "#0" : "#").append(j).append(": ").append((String)this.actions.get(i)).append('\n');
        }
        this.status2.setText(sb.toString());
        this.status2.append("");
    }

    public synchronized void setThread(int no, String s) {
        if (no == -1) {
            return;
        }
        this.threadstat[no - 1] = s;
        this.actions.set(this.threadnum[no - 1] - 1, s);
        this.refreshview();
    }

    public synchronized void setThread(int no, int retry, int actionIndex, String desc) {
        this.setThread(no, (retry == -2 || retry == -3 ? "" : (retry == -1 ? "-- " : InsertContext.num(retry + 1) + " ")) + InsertContext.ACTIONS[actionIndex] + (retry == -3 ? "   " : "") + desc);
    }

    public synchronized void removeThread(int no) {
        if (no == -1) {
            return;
        }
        this.threadstat[no - 1] = null;
        this.refreshview();
    }

    public synchronized void restart() {
        this.actions.clear();
        this.maxnum = 0;
    }

    public void done() {
        if (this.autoclose) {
            System.exit(0);
        }
        if (this.isstopping) {
            this.dispose();
        }
        this.myEngine = null;
    }

    public void iamhere(Stoppable ie) {
        this.myEngine = ie;
    }
}

