/*
 * Decompiled with CFR 0.152.
 */
package fiw.gui.awt;

import fiw.core.GUIHelper;
import fiw.core.I18n;
import fiw.core.option.DBRSlotOptionType;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class DBRSlotPanel
extends Panel
implements ActionListener {
    private DBRSlotOptionType ot;
    private TextField value;
    private int increment;
    private int offset;
    private long numvalue;
    private DBRSlotPanel following = null;
    private DBRSlotPanel preceding;

    public DBRSlotPanel(DBRSlotOptionType ot, DBRSlotPanel preceding) {
        super(new BorderLayout());
        this.ot = ot;
        this.preceding = preceding;
        Button b = new Button("<");
        this.add("West", b);
        b.addActionListener(this);
        this.value = new TextField("");
        this.add("Center", this.value);
        this.value.setEditable(false);
        b = new Button(">");
        this.add("East", b);
        b.addActionListener(this);
    }

    public void setFollowing(DBRSlotPanel following) {
        this.following = following;
    }

    public String getValue() {
        if (this.increment != 0) {
            return "" + this.numvalue;
        }
        return "";
    }

    public void setValue(String v) {
        this.increment = Integer.parseInt(this.ot.getIncrement().getValue());
        this.offset = Integer.parseInt(this.ot.getOffset().getValue());
        long val = v.equals("") ? GUIHelper.getInstance().getNextSlot(this.increment, this.offset) : Long.parseLong(v);
        this.updateValue(val);
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this.increment = 0;
            this.numvalue = 0L;
            this.value.setText(I18n.get("Slot_none"));
        }
    }

    protected void increaseValue(long v) {
        if (v > this.numvalue) {
            this.updateValue(v);
        }
    }

    private void updateValue(long newval) {
        this.numvalue = newval;
        this.value.setText(GUIHelper.getInstance().getDateString(this.numvalue * 1000L));
        if (this.following != null && newval > this.following.numvalue) {
            this.following.updateValue(newval);
        }
        if (this.preceding != null && this.preceding.numvalue > newval) {
            this.preceding.updateValue(newval);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.increment == 0) {
            return;
        }
        String cmd = evt.getActionCommand();
        if (">".equals(cmd)) {
            this.updateValue(this.numvalue + (long)this.increment);
        } else if ("<".equals(cmd)) {
            this.updateValue(this.numvalue - (long)this.increment);
        }
    }
}

