/*
 * Decompiled with CFR 0.152.
 */
package fiw.fcp;

import fiw.core.FIWSystem;
import fiw.core.InputStreamBuilder;
import fiw.core.PaddingInputStream;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPMessage;
import fiw.fcp.FECConnection;
import fiw.fcp.FECMetrics;
import fiw.fcp.FECSegmentHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class FECUtil
implements FECConnection {
    private static boolean isFree = true;
    private static FECUtil instance;
    private FCPConnection sc;
    static /* synthetic */ Class class$fiw$fcp$FECUtil;

    private FECUtil() {
    }

    protected static synchronized FECUtil getInstance(FCPConnection fc) {
        if (instance == null) {
            instance = new FECUtil();
        }
        if (!isFree) {
            return null;
        }
        isFree = false;
        FECUtil.instance.sc = fc;
        return instance;
    }

    protected static synchronized FECUtil waitForInstance(FCPConnection fc) {
        if (instance == null) {
            instance = new FECUtil();
        }
        while (!isFree) {
            try {
                (class$fiw$fcp$FECUtil == null ? FECUtil.class$("fiw.fcp.FECUtil") : class$fiw$fcp$FECUtil).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        isFree = false;
        FECUtil.instance.sc = fc;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInstance() {
        Class clazz = class$fiw$fcp$FECUtil == null ? (class$fiw$fcp$FECUtil = FECUtil.class$("fiw.fcp.FECUtil")) : class$fiw$fcp$FECUtil;
        synchronized (clazz) {
            isFree = true;
            (class$fiw$fcp$FECUtil == null ? (class$fiw$fcp$FECUtil = FECUtil.class$("fiw.fcp.FECUtil")) : class$fiw$fcp$FECUtil).notifyAll();
        }
    }

    private synchronized FECSegmentHeader[] getFECSegmentHeaders(long filelength) throws IOException {
        FECSegmentHeader[] segments = null;
        FCPMessage out = new FCPMessage("FECSegmentFile");
        out.put("AlgoName", "OnionFEC_a_1_2");
        out.put("FileLength", filelength);
        Socket s = this.sc.makeSocket();
        BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
        BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
        out.writeMessage(bos);
        int segcount = 1;
        int segnum = -1;
        while (segnum < segcount - 1) {
            FCPMessage rep = FCPMessage.readMessage(bi);
            if (rep.getCmd().equals("SegmentHeader")) {
                segcount = (int)rep.getInt("Segments");
                if (segments == null) {
                    segments = new FECSegmentHeader[segcount];
                }
                segnum = (int)rep.getInt("SegmentNum");
                int blockcount = (int)rep.getInt("BlockCount");
                int blocksize = (int)rep.getInt("BlockSize");
                int cblockcount = (int)rep.getInt("CheckBlockCount");
                int cblocksize = (int)rep.getInt("CheckBlockSize");
                segments[segnum] = new FECSegmentHeader(rep.headToString() + "EndMessage\n", blockcount, blocksize, cblockcount, cblocksize);
                continue;
            }
            if (!rep.getCmd().equals("Failed")) continue;
            System.out.println(rep.headToString());
            FIWSystem.log().println(rep.headToString());
            return null;
        }
        s.close();
        return segments;
    }

    public FECMetrics getFECMetrics(long filesize) {
        try {
            FECSegmentHeader[] segs = this.getFECSegmentHeaders(filesize);
            return new FECMetrics(segs);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public FECMetrics fecEncodeFile(File src, File dst) {
        FECMetrics fms = this.getFECMetrics(src.length());
        return this.fecEncodeFile(src, dst, fms) ? fms : null;
    }

    public boolean fecEncodeFile(File src, File dst, FECMetrics fms) {
        final File srcF = src;
        try {
            BufferedOutputStream dst_ = new BufferedOutputStream(new FileOutputStream(dst));
            InputStreamBuilder src_ = new InputStreamBuilder(){

                public InputStream buildStream() throws IOException {
                    return new BufferedInputStream(new FileInputStream(srcF));
                }
            };
            return this.fecEncodeStream(src_, (OutputStream)dst_, fms);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            ex.printStackTrace(FIWSystem.log());
            return false;
        }
    }

    public FECMetrics fecEncodeStream(InputStreamBuilder src, OutputStream dst, long datasize) {
        FECMetrics fms = this.getFECMetrics(datasize);
        return this.fecEncodeStream(src, dst, fms) ? fms : null;
    }

    public boolean fecEncodeStream(InputStreamBuilder src, OutputStream dst, FECMetrics fms) {
        try {
            FECSegmentHeader[] segments = fms.getHeads();
            if (segments.length == 0) {
                return false;
            }
            for (int iii = 0; iii < segments.length; ++iii) {
                InputStream fin = src.buildStream();
                FCPMessage out = new FCPMessage("FECEncodeSegment");
                out.put("MetadataLength", segments[iii].getHeadLength());
                out.put("DataLength", segments[iii].getRawDataLength());
                out.addTrail(segments[iii].getHead());
                for (int i = 0; i < iii; ++i) {
                    for (int x = segments[i].getDataLength(); x > 0; x -= (int)fin.skip(x)) {
                    }
                }
                out.setIS(new PaddingInputStream(fin, 0L, segments[iii].getDataLength()));
                Socket s = this.sc.makeSocket();
                BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
                BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
                out.writeMessage(bos);
                FCPMessage rep = FCPMessage.readMessage(bi);
                if (rep.getCmd().equals("Failed")) {
                    FIWSystem.log().println(rep.headToString());
                    return false;
                }
                if (rep.getCmd().equals("BlocksEncoded")) {
                    int count = (int)rep.getInt("BlockCount");
                    int size = (int)rep.getInt("BlockSize");
                    for (int read = 0; read < count * size; read += rep.getTrailing().length()) {
                        rep = FCPMessage.readMessage(bi);
                        if (rep.getCmd().equals("DataChunk")) {
                            dst.write(rep.getTrailing().toString().getBytes("ISO-8859-1"));
                            continue;
                        }
                        FIWSystem.log().println(rep.headToString());
                        return false;
                    }
                }
                bi.close();
                bos.close();
                s.close();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return false;
        }
    }

    public synchronized String makeSplitfile(long filesize, String[] blocks, String ctype, String csum) {
        try {
            String line;
            for (int i = 0; i < blocks.length; ++i) {
                if (blocks[i] != null && !"".equals(blocks[i])) continue;
                return null;
            }
            FECSegmentHeader[] segments = this.getFECSegmentHeaders(filesize);
            if (segments.length == 0) {
                return null;
            }
            int blocktotal = 0;
            int cblocktotal = 0;
            int blockdone = 0;
            int cblockdone = 0;
            for (int i = 0; i < segments.length; ++i) {
                blocktotal += segments[i].getBlockCount();
                cblocktotal += segments[i].getCheckBlockCount();
            }
            if (blocktotal + cblocktotal != blocks.length) {
                FIWSystem.log().println("FEC_SPLITFILE_ERROR: " + blocktotal + " + " + cblocktotal + " != " + blocks.length);
                return null;
            }
            cblockdone = blocktotal;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < segments.length; ++i) {
                int j;
                buf.append(segments[i].getHead());
                buf.append("BlockMap\n");
                for (j = 0; j < segments[i].getBlockCount(); ++j) {
                    buf.append("Block." + Integer.toHexString(j) + "=freenet:" + blocks[blockdone + j] + "\n");
                }
                for (j = 0; j < segments[i].getCheckBlockCount(); ++j) {
                    buf.append("Check." + Integer.toHexString(j) + "=freenet:" + blocks[cblockdone + j] + "\n");
                }
                blockdone += segments[i].getBlockCount();
                cblockdone += segments[i].getCheckBlockCount();
                buf.append("EndMessage\n");
            }
            if (blockdone != blocktotal || cblockdone != blocks.length) {
                FIWSystem.log().println("FEC_SPLITFILE_ERROR: Fatal 3819");
                return null;
            }
            Socket s = this.sc.makeSocket();
            BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
            BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
            FCPMessage out = new FCPMessage("FECMakeMetadata");
            out.put("Description", "file");
            out.put("MimeType", ctype);
            if (csum != null) {
                out.put("Checksum", csum);
            }
            out.put("DataLength", buf.length());
            out.addTrail(buf.toString());
            out.writeMessage(bos);
            boolean failed = false;
            boolean data = false;
            StringBuffer buf2 = new StringBuffer();
            while ((line = FCPMessage.readLine(bi)) != null) {
                buf2.append(line).append('\n');
                if (line.equals("Failed")) {
                    failed = true;
                    continue;
                }
                if (!line.equals("Data")) continue;
                data = true;
                buf2.setLength(0);
            }
            if (failed || !data) {
                FIWSystem.log().println("FEC_SPLITFILE: " + buf2.toString());
                return null;
            }
            return buf2.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

