/*
 * Decompiled with CFR 0.152.
 */
package fiw.fcp;

import java.util.ArrayList;
import java.util.List;

public class FECSegmentHeader {
    private String segHead;
    private int blockcount;
    private int blocksize;
    private int cblockcount;
    private int cblocksize;

    public FECSegmentHeader(String segHead, int bc, int bs, int cbc, int cbs) {
        this.segHead = segHead;
        this.blockcount = bc;
        this.blocksize = bs;
        this.cblockcount = cbc;
        this.cblocksize = cbs;
    }

    public String getHead() {
        return this.segHead;
    }

    public int getHeadLength() {
        return this.segHead.length();
    }

    public int getDataLength() {
        return this.blockcount * this.blocksize;
    }

    public int getRawDataLength() {
        return this.getHeadLength() + this.getDataLength();
    }

    public int getBlockCount() {
        return this.blockcount;
    }

    public int getCheckBlockCount() {
        return this.cblockcount;
    }

    public static List getBlockSizes(FECSegmentHeader[] fshs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < fshs.length; ++i) {
            for (int j = 0; j < fshs[i].blockcount; ++j) {
                result.add(new Integer(fshs[i].blocksize));
            }
        }
        return result;
    }

    public static List getCheckBlockSizes(FECSegmentHeader[] fshs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < fshs.length; ++i) {
            for (int j = 0; j < fshs[i].cblockcount; ++j) {
                result.add(new Integer(fshs[i].cblocksize));
            }
        }
        return result;
    }
}

