/*
 * Decompiled with CFR 0.152.
 */
package fiw.fcp;

import fiw.fcp.FECSegmentHeader;
import java.util.List;

public class FECMetrics {
    private FECSegmentHeader[] heads;

    public FECMetrics(FECSegmentHeader[] heads) {
        this.heads = heads;
    }

    protected FECSegmentHeader[] getHeads() {
        return this.heads;
    }

    public int[] getLegacyFECMetrics() {
        int i;
        List blocksizes = FECSegmentHeader.getBlockSizes(this.heads);
        List checksizes = FECSegmentHeader.getCheckBlockSizes(this.heads);
        if (this.heads.length == 0) {
            return null;
        }
        int[] ret = new int[blocksizes.size() + checksizes.size() + 1];
        for (i = 0; i < blocksizes.size(); ++i) {
            ret[i] = (Integer)blocksizes.get(i);
        }
        for (i = 0; i < checksizes.size(); ++i) {
            ret[i + blocksizes.size() + 1] = (Integer)blocksizes.get(i);
        }
        return ret;
    }

    public int[] getBlockMetrics() {
        List sizes = FECSegmentHeader.getBlockSizes(this.heads);
        if (this.heads.length == 0) {
            return null;
        }
        int[] ret = new int[sizes.size()];
        for (int i = 0; i < sizes.size(); ++i) {
            ret[i] = (Integer)sizes.get(i);
        }
        return ret;
    }

    public int[] getCheckBlockMetrics() {
        List sizes = FECSegmentHeader.getCheckBlockSizes(this.heads);
        if (this.heads.length == 0) {
            return null;
        }
        int[] ret = new int[sizes.size()];
        for (int i = 0; i < sizes.size(); ++i) {
            ret[i] = (Integer)sizes.get(i);
        }
        return ret;
    }
}

