/*
 * Decompiled with CFR 0.152.
 */
package fiw.fcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FCPMessage {
    private String commandName;
    private Hashtable fields;
    private StringBuffer trailing = new StringBuffer();
    private InputStream is;

    public FCPMessage(String cmd) {
        this.commandName = cmd;
        this.fields = new Hashtable();
    }

    public static FCPMessage readMessage(InputStream in) throws IOException {
        String line = FCPMessage.readLine(in);
        if (line == null) {
            throw new IOException("Premature end of stream");
        }
        FCPMessage message = new FCPMessage(line);
        while ((line = FCPMessage.readLine(in)) != null && !line.equals("Data") && !line.equals("EndMessage")) {
            int n = line.indexOf(61);
            String var = line.substring(0, n);
            String val = line.substring(n + 1);
            message.put(var, val);
        }
        if (line.equals("Data")) {
            int read;
            byte[] buf = new byte[16384];
            for (long len = message.getInt("Length"); len > 0L; len -= (long)read) {
                int toread = Math.min(16384, (int)len);
                read = in.read(buf, 0, toread);
                message.addTrail(new String(buf, 0, read, "ISO-8859-1"));
            }
        }
        return message;
    }

    public void writeMessage(OutputStream out) throws IOException {
        if (this.trailing.length() == 0) {
            this.trailing = null;
        }
        out.write("\u0000\u0000\u0000\u0002".getBytes("ISO-8859-1"));
        out.write(this.headToString().getBytes("ISO-8859-1"));
        if (this.trailing != null || this.is != null) {
            out.write("Data\n".getBytes("ISO-8859-1"));
        } else {
            out.write("EndMessage\n".getBytes("ISO-8859-1"));
        }
        if (this.trailing != null) {
            out.write(this.trailing.toString().getBytes("ISO-8859-1"));
        }
        if (this.is != null) {
            int len;
            byte[] b = new byte[262144];
            while ((len = this.is.read(b)) != -1) {
                out.write(b, 0, len);
            }
            this.is.close();
        }
        out.flush();
    }

    public String getCmd() {
        return this.commandName;
    }

    public String getVal(String var) {
        return (String)this.fields.get(var);
    }

    public long getInt(String var) {
        try {
            return Long.parseLong((String)this.fields.get(var), 16);
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public long getInt(String var, long defaul) {
        if (this.fields.get(var) == null) {
            return defaul;
        }
        return this.getInt(var);
    }

    public void put(String var, String val) {
        this.fields.put(var, val);
    }

    public void put(String var, int val) {
        this.fields.put(var, Integer.toHexString(val));
    }

    public void put(String var, long val) {
        this.fields.put(var, Long.toHexString(val));
    }

    public String headToString() {
        StringBuffer sb = new StringBuffer(this.commandName);
        sb.append("\n");
        Enumeration e = this.fields.keys();
        while (e.hasMoreElements()) {
            String var = (String)e.nextElement();
            sb.append(var);
            sb.append("=");
            sb.append(this.getVal(var));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.headToString();
    }

    public void addTrail(String trail) {
        this.trailing.append(trail);
    }

    public StringBuffer getTrailing() {
        return this.trailing;
    }

    public void setIS(InputStream isIn) {
        this.is = isIn;
    }

    public static String readLine(InputStream in) throws IOException {
        int chr;
        StringBuffer sb = new StringBuffer();
        boolean read = false;
        while ((chr = in.read()) != -1) {
            read = true;
            if (chr == 10) break;
            sb.append(new String(new byte[]{(byte)chr}, "ISO-8859-1"));
        }
        return read ? sb.toString() : null;
    }
}

