/*
 * Decompiled with CFR 0.152.
 */
package fiw.fcp;

import fiw.core.FIWSystem;
import fiw.core.HashUtil;
import fiw.core.InputStreamBuilder;
import fiw.fcp.DataNotFoundResult;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPGetResult;
import fiw.fcp.FCPInsertResult;
import fiw.fcp.FCPMessage;
import fiw.fcp.FECConnection;
import fiw.fcp.FECUtil;
import fiw.fcp.FingerprintResult;
import fiw.fcp.GeneralErrorResult;
import fiw.fcp.InsertSuccessResult;
import fiw.fcp.KeyCollisionResult;
import fiw.fcp.MetadataResult;
import fiw.fcp.RouteNotFoundResult;
import fiw.fcp.SSKPair;
import fiw.fcp.SocketTimeoutResult;
import fiw.fcp.URIErrorResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class FCPConn
implements FCPConnection {
    private String fcpHost = null;
    private int fcpPort = 8481;
    private List hostList = null;
    private int rrPos = 0;
    private FCPMessage lastNodeInfo = null;

    private FCPConn(String h, int p) {
        this.fcpHost = h;
        this.fcpPort = p;
    }

    private FCPConn(List hl, int port) {
        this.hostList = hl;
        this.fcpPort = port;
    }

    private FCPConn() {
    }

    public int getPort() {
        return this.fcpPort;
    }

    public String getHost() {
        if (this.hostList != null && !this.hostList.isEmpty()) {
            return (String)this.hostList.get(0);
        }
        if (this.fcpHost != null) {
            return this.fcpHost;
        }
        return null;
    }

    public List getHostList() {
        if (this.hostList != null) {
            return Collections.unmodifiableList(this.hostList);
        }
        Vector<String> l = new Vector<String>();
        if (this.fcpHost != null) {
            l.add(this.fcpHost);
        }
        return Collections.unmodifiableList(l);
    }

    public static FCPConn fcpFactory(String host, int port) {
        FIWSystem.setts().setProperty("fcp.host", host);
        FIWSystem.setts().setProperty("fcp.port", "" + port);
        if (host.indexOf(124) != -1) {
            StringTokenizer st = new StringTokenizer(host, "|");
            Vector<String> hl = new Vector<String>();
            while (st.hasMoreTokens()) {
                String h = st.nextToken();
                if (FCPConn.handshake(h, port) != null) {
                    hl.addElement(h);
                    continue;
                }
                FIWSystem.log().println("Unreachable: " + h);
                System.err.println("Unreachable: " + h);
            }
            if (hl.isEmpty()) {
                return new FCPConn();
            }
            return new FCPConn(hl, port);
        }
        if (FCPConn.handshake(host, port) != null) {
            return new FCPConn(host, port);
        }
        return new FCPConn();
    }

    private static String handshake(String host, int port) {
        try {
            Socket s = new Socket(host, port);
            FCPMessage reply = FCPConn.oneMessageEach(s, new FCPMessage("ClientHello"));
            return reply.toString();
        }
        catch (SocketException e) {
            FIWSystem.log().println("CLIENTHELLO: " + e.toString());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    public String handshake() {
        if (this.hostList == null && this.fcpHost == null) {
            return null;
        }
        List hostList = this.getHostList();
        try {
            StringBuffer result = new StringBuffer();
            Iterator it = hostList.iterator();
            while (it.hasNext()) {
                String host = (String)it.next();
                Socket s = new Socket(host, this.fcpPort);
                FCPMessage reply = FCPConn.oneMessageEach(s, new FCPMessage("ClientHello"));
                if (reply.getVal("HighestSeenBuild") != null) {
                    result.append("** before uploading, please upgrade to the latest build of Freenet **\n\n");
                }
                result.append(reply.toString());
                if (!it.hasNext()) continue;
                result.append("-----\n");
            }
            return result.toString();
        }
        catch (SocketException e) {
            FIWSystem.log().println("CLIENTHELLO: " + e.toString());
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    private FCPMessage oneMessageEach(FCPMessage out) throws IOException {
        return FCPConn.oneMessageEach(this.makeSocket(), out);
    }

    private static FCPMessage oneMessageEach(Socket s, FCPMessage out) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
        BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
        out.writeMessage(bos);
        FCPMessage lastReply = FCPMessage.readMessage(bi);
        bos.close();
        bi.close();
        s.close();
        return lastReply;
    }

    private boolean nolocal(String where) {
        return "true".equals(FIWSystem.setts().getProperty("tuning.ignorelocal." + where));
    }

    public SSKPair getNewSSK() {
        try {
            FCPMessage reply = this.oneMessageEach(new FCPMessage("GenerateSVKPair"));
            if (reply.getCmd().equals("Success")) {
                return new SSKPair(reply.getVal("PrivateKey"), reply.getVal("PublicKey"), reply.getVal("CryptoKey"));
            }
            System.err.println("--error4--" + reply.headToString());
            return new SSKPair("Unexpected reply message");
        }
        catch (IOException e) {
            e.printStackTrace(FIWSystem.log());
            e.printStackTrace();
            return new SSKPair("Unexpected error - consult logfile");
        }
    }

    public String calcCHK(String metadata, InputStreamBuilder data, long dataLength, String logname) {
        try {
            FCPMessage genchk = new FCPMessage("GenerateCHK");
            genchk.put("MetadataLength", metadata.length());
            genchk.put("DataLength", (long)metadata.length() + dataLength);
            genchk.addTrail(metadata);
            genchk.setIS(data.buildStream());
            FCPMessage ret = this.oneMessageEach(genchk);
            if (ret.getCmd().equals("Success")) {
                return ret.getVal("URI").substring(8);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace(FIWSystem.log());
            e.printStackTrace();
            return null;
        }
    }

    public FCPInsertResult insertStream(String key, String metadata, InputStreamBuilder data, int htl, long dataLength, String logname) {
        try {
            return this.insertStream(key, metadata, data.buildStream(), htl, dataLength, logname);
        }
        catch (IOException e) {
            e.printStackTrace(FIWSystem.log());
            e.printStackTrace();
            return null;
        }
    }

    public FCPInsertResult insertStream(String key, String metadata, InputStream data, int htl, long dataLength, String logname) {
        int dataLen = metadata.length() + (int)dataLength;
        if (dataLen == 0) {
            System.out.println("**** Empty keys are not allowed ****");
            FIWSystem.log().println("**** Empty keys are not allowed ****");
            return null;
        }
        try {
            Socket s = this.makeSocket();
            BufferedOutputStream out = new BufferedOutputStream(s.getOutputStream());
            BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
            FCPMessage clientput = new FCPMessage("ClientPut");
            if (htl != 0 && this.nolocal("insert")) {
                clientput.put("RemoveLocalKey", "true");
            }
            clientput.put("MetadataLength", metadata.length());
            clientput.put("URI", "freenet:" + key);
            clientput.put("DataLength", dataLen);
            clientput.put("HopsToLive", htl);
            clientput.addTrail(metadata);
            clientput.setIS(data);
            clientput.writeMessage(out);
            try {
                FCPMessage reply;
                do {
                    if ((reply = FCPMessage.readMessage(bi)).getCmd().equals("Success")) {
                        return new InsertSuccessResult(reply.getVal("URI").substring(8));
                    }
                    if (reply.getCmd().equals("KeyCollision")) {
                        return new KeyCollisionResult(reply.getVal("URI").substring(8));
                    }
                    if (reply.getCmd().equals("RouteNotFound")) {
                        return new RouteNotFoundResult((int)reply.getInt("Unreachable", 0L), (int)reply.getInt("Restarted", 0L), (int)reply.getInt("Rejected", 0L));
                    }
                    if (reply.getCmd().equals("DataNotFound")) {
                        return new RouteNotFoundResult(42, 42, 42);
                    }
                    if (!reply.getCmd().equals("FormatError")) continue;
                    System.out.println(reply.headToString());
                    FIWSystem.log().println(reply.headToString());
                    return null;
                } while (reply.getCmd().equals("Pending") || reply.getCmd().equals("Restarted"));
                System.out.println("--error3--" + reply.headToString());
                FIWSystem.log().println("--error3--" + reply.headToString());
                return null;
            }
            catch (SocketTimeoutException ex) {
                return new SocketTimeoutResult();
            }
        }
        catch (IOException e) {
            e.printStackTrace(FIWSystem.log());
            e.printStackTrace();
            return null;
        }
    }

    public FCPGetResult fetchMetadata(String key, int HTL) {
        try {
            StringBuffer metaData = new StringBuffer();
            long dataLen = 0L;
            int metaDataLen = -1;
            FCPMessage get = new FCPMessage("ClientGet");
            get.put("URI", "freenet:" + key);
            get.put("HopsToLive", HTL);
            Socket s = this.makeSocket();
            BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
            BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
            get.writeMessage(bos);
            int counter = 0;
            block3: while (counter < metaDataLen || metaDataLen == -1) {
                FCPMessage reply = FCPMessage.readMessage(bi);
                if (!reply.getCmd().equals("DataFound")) {
                    if (reply.getCmd().equals("RouteNotFound")) {
                        return new RouteNotFoundResult((int)reply.getInt("Unreachable", 0L), (int)reply.getInt("Restarted", 0L), (int)reply.getInt("Rejected", 0L));
                    }
                    if (reply.getCmd().equals("DataNotFound")) {
                        return new DataNotFoundResult();
                    }
                    if (reply.getCmd().equals("URIError")) {
                        return new URIErrorResult(reply.getVal("Reason"));
                    }
                    if (reply.getCmd().equals("Restarted")) continue;
                    if (reply.getCmd().equals("FormatError")) {
                        return new GeneralErrorResult(reply.headToString());
                    }
                    return new GeneralErrorResult(reply.headToString());
                }
                dataLen = reply.getInt("DataLength");
                metaDataLen = (int)reply.getInt("MetadataLength");
                counter = 0;
                metaData = new StringBuffer();
                while (counter < metaDataLen) {
                    FCPMessage data = FCPMessage.readMessage(bi);
                    if (data.getCmd().equals("DataChunk")) {
                        metaData.append(data.getTrailing());
                        counter = (int)((long)counter + data.getInt("Length"));
                        continue;
                    }
                    if (data.getCmd().equals("Restarted")) continue block3;
                    return new GeneralErrorResult(data.headToString());
                }
            }
            s.close();
            bos.close();
            bi.close();
            metaData.setLength(metaDataLen);
            return new MetadataResult(dataLen -= (long)metaDataLen, metaData.toString());
        }
        catch (SocketTimeoutException ex) {
            return new SocketTimeoutResult();
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return new GeneralErrorResult("");
        }
    }

    public FCPGetResult fetchFingerprint(String key, int HTL, boolean pluslocal) {
        try {
            MessageDigest fingerprint = null;
            long dataLen = -1L;
            long metaDataLen = 0L;
            FCPMessage get = new FCPMessage("ClientGet");
            if (!pluslocal && HTL != 0 && this.nolocal("fetch")) {
                get.put("RemoveLocalKey", "true");
            }
            get.put("URI", "freenet:" + key);
            get.put("HopsToLive", HTL);
            Socket s = this.makeSocket();
            BufferedOutputStream bos = new BufferedOutputStream(s.getOutputStream());
            BufferedInputStream bi = new BufferedInputStream(s.getInputStream());
            get.writeMessage(bos);
            int counter = 0;
            block4: while ((long)counter < dataLen || dataLen == -1L) {
                FCPMessage reply = FCPMessage.readMessage(bi);
                if (!reply.getCmd().equals("DataFound")) {
                    if (reply.getCmd().equals("RouteNotFound")) {
                        return new RouteNotFoundResult((int)reply.getInt("Unreachable", 0L), (int)reply.getInt("Restarted", 0L), (int)reply.getInt("Rejected", 0L));
                    }
                    if (reply.getCmd().equals("DataNotFound")) {
                        return new DataNotFoundResult();
                    }
                    if (reply.getCmd().equals("URIError")) {
                        return new URIErrorResult(reply.getVal("Reason"));
                    }
                    if (reply.getCmd().equals("Restarted")) continue;
                    if (reply.getCmd().equals("FormatError")) {
                        FIWSystem.log().println("--FormatError1--" + reply.toString());
                        return new GeneralErrorResult(reply.toString());
                    }
                    FIWSystem.log().println("--Error1--" + reply.toString());
                    return new GeneralErrorResult(reply.toString());
                }
                dataLen = reply.getInt("DataLength");
                metaDataLen = reply.getInt("MetadataLength", 0L);
                counter = 0;
                fingerprint = MessageDigest.getInstance("SHA1");
                while ((long)counter < dataLen) {
                    FCPMessage data = FCPMessage.readMessage(bi);
                    if (data.getCmd().equals("DataChunk")) {
                        String chunk = data.getTrailing().toString();
                        fingerprint.update(chunk.getBytes("ISO-8859-1"));
                        long chunkLen = data.getInt("Length");
                        counter = (int)((long)counter + chunkLen);
                        if (chunkLen == (long)chunk.length()) continue;
                        FIWSystem.log().println("Unexpected length:" + chunkLen + " != " + chunk.length());
                        return new GeneralErrorResult("---Error9---");
                    }
                    if (data.getCmd().equals("Restarted")) continue block4;
                    FIWSystem.log().println("--Error2--" + data.toString());
                    return new GeneralErrorResult(data.toString());
                }
            }
            if ((long)counter != dataLen) {
                FIWSystem.log().println("--Error5: " + counter + " != " + dataLen);
                return new GeneralErrorResult("--Error5:--");
            }
            s.close();
            bos.close();
            bi.close();
            return new FingerprintResult(metaDataLen + "/" + (dataLen - metaDataLen) + "/" + HashUtil.bytesToHex(fingerprint.digest()));
        }
        catch (SocketTimeoutException ex) {
            return new SocketTimeoutResult();
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return new GeneralErrorResult("IOException");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return new GeneralErrorResult("NoSuchAlgoritmException");
        }
    }

    public String deleteKey(String key) {
        try {
            FCPMessage out = new FCPMessage("ClientGet");
            out.put("RemoveLocalKey", "true");
            out.put("URI", "freenet:" + key);
            out.put("HopsToLive", "0");
            FCPMessage reply = this.oneMessageEach(out);
            return reply.headToString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int getNetworkLoad() {
        void var1_1;
        FCPMessage reply;
        if (this.lastNodeInfo != null) {
            reply = this.lastNodeInfo;
            this.lastNodeInfo = null;
        } else {
            try {
                reply = this.oneMessageEach(new FCPMessage("ClientInfo"));
            }
            catch (IOException e) {
                return -1;
            }
        }
        return (int)var1_1.getInt("EstimatedLoad");
    }

    public synchronized String getNodeInfo() {
        try {
            FCPMessage reply;
            this.lastNodeInfo = reply = this.oneMessageEach(new FCPMessage("ClientInfo"));
            return reply.headToString();
        }
        catch (SocketException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    public Socket makeSocket() throws IOException {
        Socket s = this.makeSocket0();
        int soTimeout = Integer.parseInt(FIWSystem.setts().getProperty("tuning.sotimeout"));
        if (s != null && soTimeout != 0) {
            s.setSoTimeout(soTimeout);
        }
        return s;
    }

    private Socket makeSocket0() throws IOException {
        for (int i = 0; i < 10; ++i) {
            String host = null;
            if (this.hostList == null) {
                host = this.fcpHost;
            } else {
                host = (String)this.hostList.get(this.rrPos);
                this.rrPos = (this.rrPos + 1) % this.hostList.size();
            }
            if (host == null) {
                throw new IOException("No FCP Connection set up");
            }
            try {
                return new Socket(host, this.fcpPort);
            }
            catch (ConnectException e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                    e2.printStackTrace(FIWSystem.log());
                    throw new IOException("Interrupted");
                }
            }
        }
        throw new IOException("Connection refused by Freenet node");
    }

    public FECConnection getFECInstance() {
        return FECUtil.getInstance(this);
    }

    public FECConnection waitForFECInstance() {
        return FECUtil.waitForInstance(this);
    }
}

