/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.I18n;
import fiw.core.option.ChoiceOptionType;
import fiw.core.option.Option;

public class SiteTypeOption
extends Option {
    private Option dbr;
    private Option ednum;

    public boolean setValue(String value) {
        if (!this.validateValue(value)) {
            return false;
        }
        this.modified = true;
        this.value = value;
        if (value.equals("DBR")) {
            this.dbr.setValue("true");
            this.ednum.setValue("0");
        } else if (value.equals("Edition")) {
            if (this.ednum.getValue().equals("0")) {
                this.ednum.setValue("1");
            }
            this.dbr.setValue("false");
        } else if (value.equals("One")) {
            this.ednum.setValue("0");
            this.dbr.setValue("false");
        }
        return true;
    }

    public void load(int project) {
        this.dbr.load(project);
        this.ednum.load(project);
        this.value = "true".equals(this.dbr.getValue()) ? "DBR" : ("0".equals(this.ednum.getValue()) ? "One" : "Edition");
        this.modified = false;
        this.loaded = true;
    }

    public void save(int project) {
        if (!this.modified) {
            return;
        }
        if (!this.loaded) {
            throw new RuntimeException("Saving an option without loading it!");
        }
        this.dbr.save(project);
        this.ednum.save(project);
        this.modified = false;
    }

    public SiteTypeOption(String name, int panel, Option dbr, Option ednum) {
        super(name, "<none>", "", panel, new ChoiceOptionType(new String[]{"DBR", "Edition", "One"}, new String[]{I18n.get("OptionDBRSite"), I18n.get("OptionEditionSite"), I18n.get("OptionOneShot")}, I18n.get("ErrUnknownSiteType")));
        this.dbr = dbr;
        this.ednum = ednum;
    }
}

