/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.I18n;
import fiw.core.ProjectKnower;
import fiw.core.option.AbstractOptions;
import fiw.core.option.DBRSlotOptionType;
import fiw.core.option.DayTimeOptionType;
import fiw.core.option.GenerateKeyButtonOption;
import fiw.core.option.IntOptionType;
import fiw.core.option.NimUpdateButtonOption;
import fiw.core.option.Option;
import fiw.core.option.OptionEnabler;
import fiw.core.option.SiteTypeOption;
import fiw.core.option.StrictIntOptionType;
import fiw.core.option.TimestampOptionType;

public class Options
extends AbstractOptions {
    private Option pubkey;
    private Option privkey;
    private Option dbr;
    private Option ednum;
    private Option inc;
    private Option offs;
    private Option nim;
    private Option checkednims;
    private Option nimprefix;
    private Option entropy;
    private OptionEnabler oe = new OptionEnabler(null, "0", false);
    private final Option[] settings;
    private int project;
    private ProjectKnower pk = null;

    private Options() {
        this.ednum = new Option(I18n.get("OptionEdition"), "editionx", "0", 8, new StrictIntOptionType(0, I18n.get("ProbsCatalogs")), this.oe);
        this.oe.setOption(this.ednum);
        this.nimprefix = new Option(I18n.get("OptionNIMPrefix"), "nimprefix", "", 5);
        this.nim = new Option(I18n.get("OptionNextNIM"), "nextnim", "1", 8, new StrictIntOptionType(1, I18n.get("ProbsNIMUtils")), new OptionEnabler(this.nimprefix, "", false));
        this.nim.setDisabledDefault("");
        this.settings = new Option[]{new Option(I18n.get("OptionProjName"), "name", "Sample project", 3), new Option(I18n.get("GenSSKPair"), 1, 1001), this.pubkey = new Option(I18n.get("OptionPubKey"), "pubkey", "", 3), this.privkey = new Option(I18n.get("OptionPrivKey"), "privkey", "", 3), this.entropy = new Option(I18n.get("OptionEntropy"), "entropy", "", 3), new GenerateKeyButtonOption(I18n.get("GenSSKPair"), 3, this.pubkey, this.privkey, this.entropy), new Option(I18n.get("OptionKeyDir"), "keydir", "samplepage", 3), new Option(I18n.get("OptionPath"), "path", "", 3), new Option(I18n.get("OptionCharset"), "charset", "", 3), this.dbr = new Option(I18n.get("OptionDBRSite"), "dbr", "false", 1000, BOOL), new SiteTypeOption(I18n.get("OptionSiteType"), 3, this.dbr, this.ednum), new Option("Check settings", 5, 1001), new Option("DBR settings header/skipper", 6, 4), this.inc = new Option(I18n.get("OptionDBRInc"), "dbr.increment", "86400", 4, new DayTimeOptionType(1)), this.offs = new Option(I18n.get("OptionDBROffs"), "dbr.offset", "0", 4, new DayTimeOptionType(0)), new Option(I18n.get("OptionALink"), "activelink", "activelink.png", 5), this.nimprefix, new Option("Additional files to parse", 4, 1001), new Option(I18n.get("OptionTitle"), "title", "My new freesite", 6), new Option(I18n.get("OptionCategory"), "category", "Software", 6), new Option(I18n.get("OptionAuthor"), "author", "anonymous", 6), new Option(I18n.get("OptionDesc"), 3, 1001), this.ednum, this.checkednims = new Option("Already found NIMs", "checkednims", "", -1), this.nim, new NimUpdateButtonOption(I18n.get("UpdateNIM"), 8, this.nim, this.checkednims, this.nimprefix), new Option(I18n.get("OptionDBRFirst"), "dbr.first", "0", 8, new DBRSlotOptionType(this.inc, this.offs), new OptionEnabler(this.dbr, "true", true)), new Option(I18n.get("OptionDBRLast"), "dbr.last", "0", 8, new DBRSlotOptionType(this.inc, this.offs), new OptionEnabler(this.dbr, "true", true)), new Option(I18n.get("OptionHTL"), "htl", "15", 8, new IntOptionType(0, 100)), new Option(I18n.get("OptionLockTime"), "lockedtime", "", 8, new TimestampOptionType())};
    }

    public Option[] getSettings() {
        return this.settings;
    }

    public Options(int project) {
        this();
        this.load(project);
    }

    public Options(ProjectKnower pk) {
        this();
        this.pk = pk;
        this.load(0);
    }

    public void load() {
        if (this.pk != null) {
            this.project = this.pk.getProjectNumber();
        }
        this.load0();
    }

    private void load0() {
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i].load(this.project);
        }
    }

    public void load(int project) {
        this.project = project;
        this.load0();
    }

    public void save() {
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i].save(this.project);
        }
    }
}

