/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.FIWSystem;
import fiw.core.option.Enabler;
import fiw.core.option.OptionType;
import fiw.core.option.StringOptionType;

public class Option {
    private int special = 0;
    private String name;
    private String prop;
    private String def;
    private String disableddef;
    protected String value;
    private int panel;
    private OptionType type;
    private Enabler enabler;
    protected boolean modified = false;
    protected boolean loaded = false;
    private static final Enabler ALWAYS_ENABLED = new Enabler(){

        public boolean isEnabled() {
            return true;
        }
    };

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        return this.prop;
    }

    public String getDefault() {
        return this.def;
    }

    public String getValue() {
        return this.value;
    }

    public OptionType getType() {
        return this.type;
    }

    public int getPanelNumber() {
        return this.panel;
    }

    public int getSpecialNumber() {
        return this.special;
    }

    public boolean isSpecial() {
        return this.special != 0;
    }

    public boolean isEnabled() {
        return this.enabler.isEnabled();
    }

    public boolean setValue(String value) {
        if (!this.validateValue(value)) {
            return false;
        }
        this.modified = true;
        this.value = value;
        return true;
    }

    public boolean validateValue(String value) {
        if (this.isSpecial()) {
            return false;
        }
        return this.type.isValid(value);
    }

    public String getInvalidReason(String value) {
        if (this.isSpecial()) {
            return "Special options cannot be set.";
        }
        return this.type.getInvalidReason(value);
    }

    public void load(int project) {
        if (this.isSpecial()) {
            return;
        }
        this.value = project == -42 ? FIWSystem.setts().getProperty(this.prop) : FIWSystem.setts().getProjectSetting(project, this.prop);
        if (this.value == null && this.isEnabled()) {
            this.value = this.def;
        }
        if (this.value == null && !this.isEnabled()) {
            this.value = this.disableddef;
        }
        this.modified = false;
        this.loaded = true;
    }

    public void save(int project) {
        if (this.isSpecial()) {
            return;
        }
        if (!this.modified) {
            return;
        }
        if (!this.loaded) {
            throw new RuntimeException("Saving an option without loading it!");
        }
        if (project == -42) {
            FIWSystem.setts().setProperty(this.prop, this.value);
        } else {
            FIWSystem.setts().saveProject(project, this.prop, this.value);
        }
        this.modified = false;
    }

    public Option(String name, String prop, String def, int panel, OptionType type, Enabler en) {
        this.name = name;
        this.prop = prop;
        this.def = def;
        this.disableddef = def;
        this.panel = panel;
        this.type = type;
        this.enabler = en;
    }

    public Option(String name, String prop, String def, int panel, OptionType type) {
        this(name, prop, def, panel, type, ALWAYS_ENABLED);
    }

    public Option(String name, String prop, String def, int panel) {
        this(name, prop, def, panel, new StringOptionType());
    }

    public Option(String desc, int specialnumber, int panel, Enabler e) {
        this.name = desc;
        this.special = specialnumber;
        this.panel = panel;
        this.enabler = e;
    }

    public Option(String desc, int specialnumber, int panel) {
        this(desc, specialnumber, panel, ALWAYS_ENABLED);
    }

    public void setDisabledDefault(String disdef) {
        this.disableddef = disdef;
    }

    public String toString() {
        return this.prop + "=" + this.value;
    }
}

