/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.option.OptionType;

public class LongOptionType
extends OptionType {
    private long min;
    private long max;

    public LongOptionType(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public LongOptionType(long min) {
        this(min, Long.MAX_VALUE);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public String getInvalidReason(String s) {
        try {
            long i = Long.parseLong(s);
            if (i >= this.min && i <= this.max) {
                return null;
            }
            return "Value must be between " + this.min + " and " + this.max;
        }
        catch (NumberFormatException ex) {
            return "Not a number: " + s;
        }
    }
}

