/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.option.OptionType;

public class IntOptionType
extends OptionType {
    private int min;
    private int max;

    public IntOptionType(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntOptionType(int min) {
        this(min, Integer.MAX_VALUE);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String getInvalidReason(String s) {
        try {
            int i = Integer.parseInt(s);
            if (i >= this.min && i <= this.max) {
                return null;
            }
            return "Value must be between " + this.min + " and " + this.max;
        }
        catch (NumberFormatException ex) {
            return "Not a number: " + s;
        }
    }
}

