/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.I18n;
import fiw.core.option.AbstractOptions;
import fiw.core.option.IntOptionType;
import fiw.core.option.Option;

public class GlobalOptions
extends AbstractOptions {
    private Option[] settings;
    private boolean loaded = false;
    private boolean useI18n;

    private void initSettings() {
        this.settings = new Option[]{new Option(this.getI18n("OptionHost"), "fcp.host", "127.0.0.1", 0), new Option(this.getI18n("OptionPort"), "fcp.port", "8481", 0, new IntOptionType(0, 65535)), new Option(this.getI18n("OptionThreads"), "tuning.threadcount", "20", 1, new IntOptionType(1, 1000)), new Option(this.getI18n("OptionFECMin"), "tuning.fecminsize", "1048576", 1, new IntOptionType(1024)), new Option(this.getI18n("OptionNoFECFor"), "tuning.nofecexts", "txt htm html", 1), new Option(this.getI18n("OptionTestVerify"), "tuning.doverifytest", "true", 1, BOOL), new Option(this.getI18n("OptionVerifyFlags"), "tuning.verifyflags", "11111111", -1), new Option(this.getI18n("OptionTestNoFEC"), "tuning.testnofec", "true", 1, BOOL), new Option(this.getI18n("OptionTestModURL"), "tuning.modifyurl", "true", 1, BOOL), new Option(this.getI18n("OptionSocketTimeout"), "tuning.sotimeout", "300000", 1, new IntOptionType(0)), new Option(this.getI18n("OptionSHA1"), "tuning.newhash", "false", 1, BOOL), new Option(this.getI18n("OptionDefPriority"), "tuning.priority", "3", 1, new IntOptionType(0)), new Option(this.getI18n("OptionThreadWait"), "tuning.threadwait", "60", 1, new IntOptionType(0)), new Option("Geeky settings", 1, 1), new Option(this.getI18n("OptionVerify"), "tuning.doverify", "true", 1, BOOL), new Option(this.getI18n("OptionInsertRetry"), "tuning.inserttry", "10", 1, new IntOptionType(1, 50)), new Option(this.getI18n("OptionFetchRetry"), "tuning.fetchtry", "5", 1, new IntOptionType(1, 50)), new Option(this.getI18n("OptionHTLInc"), "tuning.htlinc", "8", 1, new IntOptionType(0, 20)), new Option(this.getI18n("OptionRememberInserts"), "tuning.checkprogressfile", "true", 1, BOOL), new Option(this.getI18n("OptionIgnoreLocalInsert"), "tuning.ignorelocal.insert", "true", 1, BOOL), new Option(this.getI18n("OptionIgnoreLocalFetch"), "tuning.ignorelocal.fetch", "true", 1, BOOL), new Option(this.getI18n("OptionModifyTests"), "tuning.modifytests", "false", 1, BOOL), new Option(this.getI18n("OptionNIMAdvance"), "nimgetadvance", "5", 10, new IntOptionType(1)), new Option(this.getI18n("OptionNIMHTL"), "nimgethtl", "20", 10, new IntOptionType(0, 100)), new Option("Maximal size for one-key NIMs", "tuning.maxnimsize", "8192", -1), new Option("Number of projects", "proj.count", "0", -1), new Option("Allow inserting into broken DBRs [No]", "tuning.nodbrmismatch", "false", -1, BOOL), new Option("FProxy URL", "fproxy.url", "http://127.0.0.1:8888/", -1), new Option("Locale", "locale", "", -1)};
    }

    public Option[] getSettings() {
        return this.settings;
    }

    public GlobalOptions() {
        this(true);
    }

    public GlobalOptions(boolean load) {
        this(load, true);
    }

    public GlobalOptions(boolean load, boolean useI18n) {
        this.useI18n = useI18n;
        this.initSettings();
        if (load) {
            this.load();
        }
    }

    private String getI18n(String name) {
        if (this.useI18n) {
            return I18n.get(name);
        }
        return "!No I18n available!";
    }

    public void load() {
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i].load(-42);
        }
        this.loaded = true;
    }

    public void save() {
        if (!this.loaded) {
            throw new RuntimeException("You must load before saving...");
        }
        for (int i = 0; i < this.settings.length; ++i) {
            this.settings[i].save(-42);
        }
    }
}

