/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.option;

import fiw.core.FIWSystem;
import fiw.core.Settings;
import fiw.core.option.ButtonOption;
import fiw.core.option.Option;
import fiw.fcp.FCPConnection;
import fiw.fcp.SSKPair;

public class GenerateKeyButtonOption
extends ButtonOption {
    private Option pubkey;
    private Option privkey;
    private Option entropy;

    public GenerateKeyButtonOption(String title, int panel, Option pubkey, Option privkey, Option entropy) {
        super(title, panel, false);
        this.pubkey = pubkey;
        this.privkey = privkey;
        this.entropy = entropy;
    }

    public Option[] getAffectedOptions() {
        return new Option[]{this.pubkey, this.privkey, this.entropy};
    }

    public void handleAction() {
        String pub = this.pubkey.getValue();
        if (pub.startsWith("#")) {
            try {
                int num = Integer.parseInt(pub.substring(1));
                Settings ss = FIWSystem.getInstance().getSettings();
                if (num > 0 && num <= ss.getProjCount()) {
                    this.pubkey.setValue(ss.getProjectSetting(num - 1, "pubkey"));
                    this.privkey.setValue(ss.getProjectSetting(num - 1, "privkey"));
                    this.entropy.setValue(ss.getProjectSetting(num - 1, "entropy"));
                    return;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        FCPConnection fc = FIWSystem.getInstance().getFCPConnection();
        SSKPair kp = fc.getNewSSK();
        this.privkey.setValue(kp.getPrivateKey());
        this.pubkey.setValue(kp.getPublicKey());
        this.entropy.setValue(kp.getEntropy());
    }
}

