/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.insert.InsertContext;
import fiw.core.jobs.FECBuilderJob;
import fiw.core.jobs.FilePartInsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataProducing;
import fiw.fcp.FCPConnection;
import fiw.fcp.FECConnection;

public class SplitfileBuilderJob
extends Job
implements MetadataProducing {
    private InsertContext ic;
    private FCPConnection fc;
    private String filename;
    private String ctype;
    private String metadata;
    private long filelen;

    public SplitfileBuilderJob(long filelen, String filename, String ctype, InsertContext ic, Job[] dependencies) {
        super(true, dependencies, "Splitfile builder for " + filename);
        this.filename = filename;
        this.ctype = ctype;
        this.filelen = filelen;
        this.ic = ic;
        this.fc = ic.getFCPConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        Job[] deps = this.getDependencies();
        String sha1 = ((FECBuilderJob)deps[0]).getSHA1();
        String[] blocks = new String[deps.length - 1];
        for (int i = 1; i < deps.length; ++i) {
            blocks[i - 1] = ((FilePartInsertJob)deps[i]).getResultKey();
        }
        if (sha1 == null) {
            throw new RuntimeException("assert failed: sha1 != null");
        }
        FECConnection encoder = this.fc.getFECInstance();
        try {
            if (encoder == null) {
                this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Waiting until FEC encoder is free..");
                encoder = this.fc.waitForFECInstance();
            }
            this.metadata = encoder.makeSplitfile(this.filelen, blocks, this.ctype, sha1);
            if (this.metadata == null) {
                this.ic.addlog("[ERROR] Cannot generate splitfile for " + this.filename + " ***************");
                int n = 2;
                return n;
            }
        }
        finally {
            if (encoder != null) {
                encoder.releaseInstance();
            }
        }
        return 0;
    }

    public String produceMetadata() {
        if (!this.metadata.startsWith("Version\nRevision=1\n") || !this.metadata.endsWith("End\n")) {
            return null;
        }
        String metadata2 = this.metadata.substring(19, this.metadata.length() - 4);
        return metadata2;
    }
}

