/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.insert.InsertContext;
import fiw.core.insert.event.JobChangeInsertEvent;
import fiw.core.insert.event.JobFailureEvent;
import fiw.core.insert.event.JobGettingInsertEvent;
import fiw.core.insert.event.JobInitInsertEvent;
import fiw.core.insert.event.JobSuccessEvent;
import fiw.core.insert.event.StructuredJobInsertEvent;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.fcp.DataNotFoundResult;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPGetResult;
import fiw.fcp.FingerprintResult;
import fiw.fcp.RouteNotFoundResult;
import fiw.fcp.SocketTimeoutResult;
import fiw.fcp.URIErrorResult;

public class RetrieveCheckJob
extends Job {
    private String key;
    private String progressName;
    private String fingerprint;
    private int htl;
    private int fixNumber = -1;
    private InsertContext ic;
    private FCPConnection fc;

    public RetrieveCheckJob(String key, String fingerprint, String name, String progressName, InsertContext ic, Job[] dependencies) {
        super(true, dependencies, name);
        this.key = key;
        this.htl = ic.fetchHTL;
        this.fingerprint = fingerprint;
        this.progressName = progressName;
        this.ic = ic;
        this.fc = ic.getFCPConnection();
    }

    public String getKey() {
        return this.key;
    }

    public int foreignRun(int number, int fixNumber) {
        this.myNumber = number;
        this.fixNumber = fixNumber;
        return this.runInternal();
    }

    public boolean shouldRun() {
        Job[] deps = this.getDependencies();
        Job dep = null;
        if (deps != null && deps.length > 0) {
            dep = deps[0];
        }
        if (dep instanceof InsertJob) {
            if (this.key == null) {
                this.key = ((InsertJob)dep).getResultKey();
            }
            if (this.fingerprint == null) {
                this.fingerprint = ((InsertJob)dep).getFingerprint();
            }
            if (this.progressName == null) {
                this.progressName = ((InsertJob)dep).getProgressName();
            }
        }
        if ("!none!".equals(this.key)) {
            return false;
        }
        return super.shouldRun();
    }

    public int run() {
        this.ic.fireInsertEvent(new JobInitInsertEvent(this.myNumber));
        this.ic.fireInsertEvent(new JobChangeInsertEvent(this.myNumber, this.name, InsertContext.ACTIONS[0]));
        this.ic.fireInsertEvent(new JobGettingInsertEvent(this.myNumber, this.name, -1));
        int result = this.runInternal();
        if (result != 0) {
            if (this.progressName != null) {
                this.ic.dataNotInserted(this.progressName);
            }
            this.ic.fireInsertEvent(new JobFailureEvent(this.myNumber, this.name, null));
            if (result == 3) {
                this.ic.setRetryFutile();
            }
        } else {
            this.ic.fireInsertEvent(new JobSuccessEvent(this.myNumber, this.name));
        }
        return result;
    }

    private int runInternal() {
        if (this.key == null) {
            throw new RuntimeException("assert: key not null");
        }
        if (this.fingerprint == null) {
            throw new RuntimeException("assert: fingerprint not null");
        }
        boolean exitDNF = false;
        for (int j = 0; j < this.ic.RETRIEVERETRY; ++j) {
            String j2;
            int jj;
            int n = jj = this.fixNumber == -1 ? j : this.fixNumber;
            String string = this.fixNumber == -1 ? "" : (j2 = "(" + InsertContext.num(j + 1) + ") ");
            if (this.ic.shouldStop()) {
                return 1;
            }
            this.ic.addlog(this.myNumber, jj, 3, j2 + this.name);
            FCPGetResult fetch = this.fc.fetchFingerprint(this.key, this.htl + (exitDNF ? 1 : 0), false);
            if (fetch instanceof FingerprintResult) {
                this.ic.notAllUnreachable();
                this.ic.addlog(this.myNumber, jj, 4, this.name);
                if (this.fingerprint.equals("-")) {
                    return 0;
                }
                if (fetch.getPayload().equals(this.fingerprint)) {
                    this.ic.addlog(this.myNumber, jj, 13, this.name);
                    return 0;
                }
                this.ic.addlog(this.myNumber, jj, 14, this.name);
                this.ic.addlog("      GOT:    " + fetch.getPayload());
                this.ic.addlog("      SHOULD: " + this.fingerprint);
                break;
            }
            if (fetch instanceof RouteNotFoundResult) {
                RouteNotFoundResult rnfr = (RouteNotFoundResult)fetch;
                this.ic.addlog(this.myNumber, jj, 6, this.name + " " + rnfr.getReasonString());
                if (rnfr.isAllUnreachable()) {
                    if (!this.ic.allUnreachable()) continue;
                    break;
                }
                this.ic.notAllUnreachable();
                continue;
            }
            if (fetch instanceof SocketTimeoutResult) {
                this.ic.fireInsertEvent(new StructuredJobInsertEvent(this.myNumber, jj, "***Timeout ", this.name));
                this.ic.notAllUnreachable();
                continue;
            }
            if (fetch instanceof DataNotFoundResult) {
                this.ic.notAllUnreachable();
                this.ic.addlog(this.myNumber, jj, 7, this.name);
                if (exitDNF || this.htl == 0) break;
                exitDNF = true;
                continue;
            }
            if (fetch instanceof URIErrorResult) {
                URIErrorResult uer = (URIErrorResult)fetch;
                this.ic.notAllUnreachable();
                if (uer.getReason().equals("Data found, but failed to decrypt with the decryption key given in the URI.")) {
                    this.ic.addlog("#" + this.myNumber + ": [Error] Key already exists with different " + "crypto key! Please insert into another key.");
                } else {
                    this.ic.addlog("#" + this.myNumber + "[Error] URI error while fetching.");
                    this.ic.addlog("Reason: " + uer.getReason());
                }
                return 3;
            }
            this.ic.addlog("[ERROR] #" + InsertContext.num(this.myNumber) + ": internal error - consult logfile");
        }
        return 2;
    }
}

