/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.jobs.Job;
import fiw.core.jobs.ThreadProducer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PooledThreadProducer
implements ThreadProducer {
    private long keepDelay;
    private volatile boolean stopAll = false;
    private List freeThreads;
    private Object syncObject;

    public PooledThreadProducer(long keepDelay) {
        this.keepDelay = keepDelay;
        this.freeThreads = new ArrayList();
        this.syncObject = new Object();
    }

    public void initialize() {
        this.stopAll = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceThread(Job j) {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.freeThreads.isEmpty()) {
                PooledThread t = new PooledThread();
                t.setJob(j);
                t.start();
            } else {
                PooledThread t;
                PooledThread pooledThread = t = (PooledThread)this.freeThreads.get(0);
                synchronized (pooledThread) {
                    t.setJob(j);
                    this.freeThreads.remove(t);
                    t.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        Object object = this.syncObject;
        synchronized (object) {
            this.stopAll = true;
            Iterator it = new ArrayList(this.freeThreads).iterator();
            while (it.hasNext()) {
                PooledThread t;
                PooledThread pooledThread = t = (PooledThread)it.next();
                synchronized (pooledThread) {
                    t.notifyAll();
                }
            }
        }
    }

    private class PooledThread
    extends Thread {
        private Job jobToRun = null;

        private PooledThread() {
        }

        public synchronized void setJob(Job j) {
            if (this.jobToRun != null) {
                throw new IllegalStateException("There is already a job.");
            }
            this.jobToRun = j;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            PooledThread pooledThread = this;
            synchronized (pooledThread) {
                if (this.jobToRun == null) {
                    throw new IllegalStateException("Nothing to run.");
                }
            }
            try {
                while (true) {
                    Job j;
                    PooledThread pooledThread2 = this;
                    synchronized (pooledThread2) {
                        if (this.jobToRun == null) {
                            return;
                        }
                        j = this.jobToRun;
                        this.jobToRun = null;
                    }
                    j.run0();
                    if (PooledThreadProducer.this.stopAll) {
                        return;
                    }
                    long now = System.currentTimeMillis();
                    Object object = PooledThreadProducer.this.syncObject;
                    synchronized (object) {
                        PooledThreadProducer.this.freeThreads.add(this);
                    }
                    object = this;
                    synchronized (object) {
                        while (this.jobToRun == null && !PooledThreadProducer.this.stopAll) {
                            if (PooledThreadProducer.this.keepDelay == 0L) {
                                this.wait();
                                continue;
                            }
                            this.wait(PooledThreadProducer.this.keepDelay);
                            if (System.currentTimeMillis() - now >= PooledThreadProducer.this.keepDelay) continue;
                        }
                    }
                    object = PooledThreadProducer.this.syncObject;
                    synchronized (object) {
                        PooledThreadProducer.this.freeThreads.remove(this);
                    }
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

