/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.HashUtil;
import fiw.core.NullStreamBuilder;
import fiw.core.insert.InsertContext;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataProducing;

public class MetadataInsertJob
extends InsertJob {
    private String key;
    private boolean metadataNull;

    public MetadataInsertJob(String key, String metadata, String name, InsertContext ic, Job[] dependencies) {
        super(key, metadata, new NullStreamBuilder(), 0L, name, MetadataInsertJob.makeProgressName(key, metadata), ic, dependencies);
        this.metadataNull = metadata == null;
        this.key = key;
    }

    private static String makeProgressName(String key, String metadata) {
        return HashUtil.calcMD5(metadata + key);
    }

    public boolean shouldRun() {
        Job dep;
        if (this.metadataNull && (dep = this.getDependency()) instanceof MetadataProducing) {
            this.metadataNull = false;
            String newMetadata = "Version\nRevision=1\n" + ((MetadataProducing)((Object)dep)).produceMetadata() + "End\n";
            this.setMetadata(newMetadata);
            this.setProgressName("Metadata." + MetadataInsertJob.makeProgressName(this.key, newMetadata));
        }
        return super.shouldRun();
    }
}

