/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.jobs.JobScheduler;

public abstract class Job {
    private boolean threaded;
    private Job[] dependencies;
    private boolean finished = false;
    private boolean successful = true;
    private JobScheduler scheduler;
    protected int myNumber;
    protected String name;
    private boolean shouldrun;

    public Job(boolean threaded, Job[] dependencies, String name) {
        this.threaded = threaded;
        this.dependencies = dependencies;
        this.name = name;
    }

    protected Job[] getDependencies() {
        return this.dependencies;
    }

    protected Job getDependency() {
        if (this.dependencies != null && this.dependencies.length == 1) {
            return this.dependencies[0];
        }
        return null;
    }

    public boolean isThreaded() {
        return this.threaded;
    }

    public synchronized boolean hasFinished() {
        return this.finished;
    }

    public synchronized boolean wasSuccessful() {
        return this.successful;
    }

    public boolean isReadyToRun() {
        if (this.finished) {
            return false;
        }
        for (int i = 0; i < this.dependencies.length; ++i) {
            if (this.dependencies[i].hasFinished()) continue;
            return false;
        }
        return true;
    }

    public void start(JobScheduler sched, int myNumber) {
        if (this.finished) {
            throw new IllegalStateException("Job already finished");
        }
        this.myNumber = myNumber;
        this.scheduler = sched;
        for (int i = 0; i < this.dependencies.length; ++i) {
            if (!this.dependencies[i].hasFinished()) {
                throw new IllegalStateException("Dependency error: " + this + " depends on " + this.dependencies[i]);
            }
            if (this.dependencies[i].wasSuccessful()) continue;
            sched.notifySkipping(this);
            this.finished = true;
            this.successful = false;
            sched.notifyFinished(this);
            return;
        }
        this.shouldrun = this.shouldRun();
        if (this.shouldrun && this.isThreaded()) {
            sched.runAsThread(this);
        } else {
            this.run0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run0() {
        int s = this.shouldrun ? this.run() : 0;
        Job job = this;
        synchronized (job) {
            this.finished = true;
            switch (s) {
                case 0: {
                    this.successful = true;
                    break;
                }
                case 1: {
                    this.successful = false;
                    break;
                }
                case 2: {
                    this.successful = false;
                    this.scheduler.notifyError(false);
                    break;
                }
                case 3: {
                    this.successful = false;
                    this.scheduler.notifyError(true);
                }
            }
        }
        this.scheduler.notifyFinished(this);
    }

    public String toString() {
        return this.name;
    }

    public abstract int run();

    public boolean shouldRun() {
        return true;
    }
}

