/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.HashUtil;
import fiw.core.InputStreamBuilder;
import fiw.core.insert.InsertContext;
import fiw.core.insert.KeyFallback;
import fiw.core.insert.NoKeyFallback;
import fiw.core.insert.event.JobAbortEvent;
import fiw.core.insert.event.JobChangeInsertEvent;
import fiw.core.insert.event.JobFailureEvent;
import fiw.core.insert.event.JobFinishedEvent;
import fiw.core.insert.event.JobGettingInsertEvent;
import fiw.core.insert.event.JobInitInsertEvent;
import fiw.core.insert.event.JobSkippedInsertEvent;
import fiw.core.insert.event.JobSuccessEvent;
import fiw.core.insert.event.JobUppingInsertEvent;
import fiw.core.insert.event.StructuredJobInsertEvent;
import fiw.core.insert.event.UploadedJobInsertEvent;
import fiw.core.jobs.Job;
import fiw.core.jobs.RetrieveCheckJob;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPGetResult;
import fiw.fcp.FCPInsertResult;
import fiw.fcp.FingerprintResult;
import fiw.fcp.InsertSuccessResult;
import fiw.fcp.KeyCollisionResult;
import fiw.fcp.RouteNotFoundResult;
import fiw.fcp.SocketTimeoutResult;

public class InsertJob
extends Job {
    private String key;
    private String progressName;
    private String metadata;
    private String fingerprint = null;
    private String keycollisionwarning = null;
    private InputStreamBuilder data;
    private long dataLength;
    private InsertContext ic;
    private FCPConnection fc;
    private boolean keyCollision = false;
    private boolean keyCollisionOkay = false;
    private KeyFallback fallback;
    protected String resultKey;
    protected boolean loggerStarted = false;
    protected boolean calcOnly = false;
    private static KeyFallback defaultFallback = new NoKeyFallback();

    public InsertJob(String key, String metadata, InputStreamBuilder data, long dataLength, String name, String progressName, InsertContext ic, Job[] dependencies) {
        super(true, dependencies, name);
        this.key = key;
        this.metadata = metadata;
        this.data = data;
        this.dataLength = dataLength;
        this.progressName = progressName;
        this.ic = ic;
        this.fc = ic.getFCPConnection();
        this.fallback = defaultFallback;
    }

    protected void getLoggerNumber() {
        if (!this.loggerStarted) {
            this.ic.fireInsertEvent(new JobInitInsertEvent(this.myNumber));
            this.loggerStarted = true;
        }
    }

    public void setFallback(KeyFallback f) {
        this.fallback = f;
    }

    public void setCalcOnly() {
        if (!"CHK@".equals(this.key)) {
            throw new RuntimeException("assert: calcCHK only for CHKs!");
        }
        this.calcOnly = true;
    }

    public void setKeyCollisionOkay() {
        this.keyCollisionOkay = true;
    }

    public void setKeyCollisionWarning(String warning) {
        this.keycollisionwarning = warning;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setProgressName(String progressName) {
        this.progressName = progressName;
    }

    public String getProgressName() {
        return this.progressName;
    }

    public void setData(InputStreamBuilder data, long dataLength) {
        this.data = data;
        this.dataLength = dataLength;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getResultKey() {
        return this.resultKey;
    }

    public boolean isKeyCollision() {
        return this.keyCollision;
    }

    public boolean shouldRun() {
        if (this.metadata == null) {
            throw new RuntimeException("assert: metadata for insert present");
        }
        if (this.data == null) {
            throw new RuntimeException("assert: data for insert present");
        }
        if (this.progressName == null) {
            throw new RuntimeException("assert: proressName for insert present");
        }
        if (this.calcOnly) {
            this.progressName = "Calc." + this.progressName;
        } else {
            this.fingerprint = HashUtil.makeFingerprint(this.metadata, this.data, this.dataLength);
            if (this.fingerprint.equals("")) {
                this.ic.addlog("[Warning] Could not generate fingerprint of " + this);
            }
        }
        this.getLoggerNumber();
        String res = this.ic.alreadyDone(this.progressName);
        if (res != null) {
            this.resultKey = res;
            if (this.keyCollisionOkay) {
                this.fingerprint = "-";
            }
            this.ic.fireInsertEvent(new JobSkippedInsertEvent(this.myNumber, this.name));
            return false;
        }
        this.ic.fireInsertEvent(new JobChangeInsertEvent(this.myNumber, this.name, InsertContext.ACTIONS[0]));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int run() {
        if (this.metadata == null || this.data == null || this.progressName == null) {
            throw new RuntimeException("assert: data for insert present");
        }
        this.getLoggerNumber();
        if (this.calcOnly) {
            this.ic.fireInsertEvent(new JobChangeInsertEvent(this.myNumber, this.name, InsertContext.ACTIONS[18]));
            this.resultKey = this.fc.calcCHK(this.metadata, this.data, this.dataLength, this.name);
            if (this.resultKey == null) {
                this.ic.fireInsertEvent(new JobFailureEvent(this.myNumber, this.name, "[Error] unexpected error - consult logfile"));
                return 2;
            }
            this.ic.dataInserted(this.progressName, this.resultKey);
            this.ic.fireInsertEvent(new JobFinishedEvent(this.myNumber, this.name));
            return 0;
        }
        for (int i = 0; i < this.ic.INSERTRETRY && !this.ic.shouldStop() && !this.ic.isAllUnreachable(); ++i) {
            FCPInsertResult res;
            block21: {
                block22: {
                    FCPGetResult comp;
                    block23: {
                        this.ic.fireInsertEvent(new JobUppingInsertEvent(this.myNumber, this.name, i));
                        res = this.fc.insertStream(this.key, this.metadata, this.data, this.ic.htl, this.dataLength, "INSERT(" + this.name + ")");
                        if (res == null) {
                            this.ic.addlog("[ERROR] #" + InsertContext.num(this.myNumber) + ": " + this.name + ": internal error - consult logfile");
                            this.resultKey = null;
                            continue;
                        }
                        if (res instanceof RouteNotFoundResult) {
                            RouteNotFoundResult rnfr = (RouteNotFoundResult)res;
                            this.ic.addlog(this.myNumber, i, 6, this.name + " " + rnfr.getReasonString());
                            if (rnfr.isAllUnreachable()) {
                                if (this.ic.allUnreachable()) {
                                    break;
                                }
                            } else {
                                this.ic.notAllUnreachable();
                            }
                            this.resultKey = null;
                            continue;
                        }
                        if (res instanceof SocketTimeoutResult) {
                            this.ic.fireInsertEvent(new StructuredJobInsertEvent(this.myNumber, i, "***Timeout ", this.name));
                            this.ic.notAllUnreachable();
                            this.resultKey = null;
                            continue;
                        }
                        if (!(res instanceof KeyCollisionResult)) break block22;
                        this.ic.notAllUnreachable();
                        this.ic.fireInsertEvent(new UploadedJobInsertEvent(this.myNumber, i, true, this.name, res.getKey()));
                        if (this.key.equals("CHK@")) break block21;
                        if (this.ic.shouldStop()) break;
                        this.ic.addlog(this.myNumber, i, 12, this.name);
                        comp = this.fc.fetchFingerprint(res.getKey(), this.ic.fetchHTL, true);
                        if (comp != null && comp instanceof FingerprintResult) break block23;
                        this.ic.addlog("[Error] could not get colliding key!");
                        break block21;
                    }
                    if (comp.getPayload().equals(this.fingerprint)) {
                        this.ic.addlog(this.myNumber, i, 13, this.name);
                        break block21;
                    } else {
                        this.ic.addlog(this.myNumber, i, 14, this.name);
                        if (this.keyCollisionOkay) {
                            this.fingerprint = "-";
                            this.keyCollision = true;
                            this.ic.addlog("[Warning] Key collision on non-CHK file!");
                            break block21;
                        } else {
                            String nkey = this.fallback.nextKey(this.key);
                            if (nkey == null) {
                                this.keyCollision = true;
                                this.ic.fireInsertEvent(new JobFailureEvent(this.myNumber, this.name, "[Error] Key collision on non-CHK file!"));
                                if (this.keycollisionwarning != null) {
                                    this.ic.addlog(this.keycollisionwarning);
                                }
                                this.ic.setRetryFutile();
                                return 3;
                            }
                            this.key = nkey;
                            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " ** now trying: " + this.key);
                            i = -1;
                            continue;
                        }
                    }
                }
                if (!(res instanceof InsertSuccessResult)) {
                    throw new RuntimeException("Unknown result: " + res.getClass());
                }
                this.ic.notAllUnreachable();
                this.ic.fireInsertEvent(new UploadedJobInsertEvent(this.myNumber, i, false, this.name, res.getKey()));
            }
            this.resultKey = res.getKey();
            if (!this.keyCollision) {
                this.ic.dataInserted(this.progressName, this.resultKey);
            }
            if (!this.ic.doVerify(false)) break;
            this.ic.fireInsertEvent(new JobGettingInsertEvent(this.myNumber, this.name, i));
            RetrieveCheckJob r = this.buildChecker(false, this.resultKey, null);
            int cfa = r.foreignRun(this.myNumber, i);
            if (cfa == 0) break;
            if (cfa == 3) {
                this.ic.fireInsertEvent(new JobFailureEvent(this.myNumber, this.name, null));
                this.ic.setRetryFutile();
                return 3;
            }
            this.resultKey = null;
            this.ic.dataNotInserted(this.progressName);
        }
        if (this.ic.shouldStop()) {
            this.resultKey = null;
            this.ic.fireInsertEvent(new JobAbortEvent(this.myNumber, this.name));
            return 1;
        }
        if (this.resultKey != null && !this.ic.isAllUnreachable()) {
            this.ic.fireInsertEvent(new JobSuccessEvent(this.myNumber, this.name));
            return 0;
        }
        this.ic.fireInsertEvent(new JobFailureEvent(this.myNumber, this.name, null));
        return 2;
    }

    public RetrieveCheckJob buildChecker(boolean depending, String key, Job extraJob) {
        Job[] jobArray;
        if (this.calcOnly) {
            throw new RuntimeException("assert: cannot verify chk calculation of " + this);
        }
        if (depending) {
            Job[] jobArray2 = new Job[2];
            jobArray2[0] = this;
            jobArray = jobArray2;
            jobArray2[1] = extraJob;
        } else {
            jobArray = new Job[]{};
        }
        Job[] deps = jobArray;
        return new RetrieveCheckJob(key, this.fingerprint, this.name, this.progressName, this.ic, deps);
    }
}

