/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.insert.InsertContext;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataInsertJob;
import fiw.core.jobs.MetadataProducing;

public class IndirectMapfileInsertJob
extends MetadataInsertJob
implements MetadataProducing {
    private InsertContext ic;
    private boolean giveNoise;
    private String myMetadata = null;

    public IndirectMapfileInsertJob(InsertContext ic, boolean giveNoise, Job[] dependencies) {
        super("CHK@", null, "indirect mapfile", ic, dependencies);
        this.ic = ic;
        this.giveNoise = giveNoise;
    }

    public boolean shouldRun() {
        Job dep = this.getDependency();
        if (!(dep instanceof MetadataProducing)) {
            throw new RuntimeException("assert: indirect mapfile gets metadata");
        }
        this.myMetadata = ((MetadataProducing)((Object)dep)).produceMetadata();
        if (this.giveNoise) {
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Mapfile size: " + this.myMetadata.length() + " bytes.");
        }
        if (this.myMetadata.length() < 32500) {
            this.resultKey = "!none!";
            return false;
        }
        if (this.giveNoise) {
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Mapfile exceeds 32K limit.");
        }
        this.myMetadata = null;
        return super.shouldRun();
    }

    public String produceMetadata() {
        if (this.myMetadata != null) {
            return this.myMetadata;
        }
        return "EndPart\nDocument\nRedirect.Target=freenet:" + this.getResultKey() + "\n";
    }
}

