/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.InputStreamBuilder;
import fiw.core.PaddingInputStream;
import fiw.core.insert.InsertContext;
import fiw.core.jobs.FileProducing;
import fiw.core.jobs.HashProducing;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilePartInsertJob
extends InsertJob
implements InputStreamBuilder {
    private File f;
    private boolean checkChunk;
    private String filename;
    private String hash = null;
    private long start;
    private long length;
    private int number;
    private InsertContext ic;

    public FilePartInsertJob(File f, String filename, long start, long length, int number, boolean checkChunk, InsertContext ic, Job[] deps) {
        super("CHK@", "", null, 0L, filename + " (Ch" + (checkChunk ? "eck ch" : "") + "unk " + number + ")", null, ic, deps);
        this.f = f;
        this.start = start;
        this.length = length;
        this.checkChunk = checkChunk;
        this.filename = filename;
        this.ic = ic;
        this.number = number;
    }

    public FilePartInsertJob(FilePartInsertJob toClone) {
        this(toClone.f, toClone.filename, toClone.start, toClone.length, toClone.number, toClone.checkChunk, toClone.ic, toClone.getDependencies());
    }

    public boolean shouldRun() {
        Job dep;
        if (this.f == null && (dep = this.getDependency()) instanceof FileProducing) {
            this.f = ((FileProducing)((Object)dep)).produceFile();
        }
        if (this.hash == null && (dep = this.getDependency()) instanceof HashProducing) {
            this.hash = ((HashProducing)((Object)dep)).produceHash();
        }
        this.setData(this, this.length);
        if (this.hash != null) {
            this.setProgressName((this.checkChunk ? "Check" : "") + "Chunk." + this.hash + "." + this.start);
        }
        return super.shouldRun();
    }

    public InputStream buildStream() throws IOException {
        return new BufferedInputStream(new PaddingInputStream(new FileInputStream(this.f), this.start, this.length));
    }
}

