/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.InputStreamBuilder;
import fiw.core.insert.InsertContext;
import fiw.core.jobs.FileProducing;
import fiw.core.jobs.HashProducing;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataProducingEx;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInsertJob
extends InsertJob
implements MetadataProducingEx,
InputStreamBuilder {
    private File f;
    private boolean isDefault;
    private String ctype;
    private String filename;
    private String hash;

    public FileInsertJob(File f, String filename, String ctype, String hash, boolean isDefault, boolean modifyMetadata, InsertContext ic, Job[] deps) {
        this(f, filename, ctype, hash, isDefault, "CHK@", "Version\nRevision=1\nEnd\n" + (modifyMetadata ? "Comment=FIW_Test\n" : ""), ic, deps);
    }

    public FileInsertJob(File f, String filename, String ctype, String hash, boolean isDefault, String key, String metadata, InsertContext ic, Job[] deps) {
        super(key, metadata, null, 0L, filename, null, ic, deps);
        this.f = f;
        this.isDefault = isDefault;
        this.ctype = ctype;
        this.filename = filename;
        this.hash = hash;
    }

    public boolean shouldRun() {
        Job dep;
        if (this.f == null && (dep = this.getDependency()) instanceof FileProducing) {
            this.f = ((FileProducing)((Object)dep)).produceFile();
        }
        if (this.hash == null && (dep = this.getDependency()) instanceof HashProducing) {
            this.hash = ((HashProducing)((Object)dep)).produceHash();
        }
        this.setData(this, this.f.length());
        if (this.hash != null) {
            this.setProgressName("File." + this.hash);
        }
        return super.shouldRun();
    }

    public InputStream buildStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.f));
    }

    public String produceMetadata() {
        if (!this.isDefault) {
            return "";
        }
        return "EndPart\nDocument\nRedirect.Target=freenet:" + this.getResultKey() + (this.ctype == null ? "" : "\nInfo.Format=" + this.ctype) + "\n";
    }

    public String produceMetadataEx() {
        return "EndPart\nDocument\nRedirect.Target=freenet:" + this.getResultKey() + "\nName=" + this.filename + (this.ctype == null ? "" : "\nInfo.Format=" + this.ctype) + "\n";
    }
}

