/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.insert.InsertContext;
import fiw.core.jobs.FileProducing;
import fiw.core.jobs.HashCalcJobEx;
import fiw.core.jobs.HashProducing;
import fiw.core.jobs.Job;
import fiw.fcp.FCPConnection;
import fiw.fcp.FECConnection;
import fiw.fcp.FECMetrics;
import java.io.File;
import java.util.Properties;

public class FECBuilderJob
extends Job
implements FileProducing,
HashProducing {
    private InsertContext ic;
    private FCPConnection fc;
    private File file;
    private File fecDataDir;
    private File checkfile = null;
    private String fecToken;
    private String filename;
    private String sha1 = null;
    private String hash = null;
    private FECMetrics fecMetrics;
    private Properties fecProgress;

    public FECBuilderJob(File file, String filename, Properties fecProgress, String fecToken, File fecDataDir, FECMetrics fecMetrics, InsertContext ic, Job[] dependencies) {
        super(true, dependencies, "FEC encoding " + filename);
        this.file = file;
        this.filename = filename;
        this.fecProgress = fecProgress;
        this.fecToken = fecToken;
        this.fecDataDir = fecDataDir;
        this.fecMetrics = fecMetrics;
        this.ic = ic;
        this.fc = ic.getFCPConnection();
    }

    public boolean shouldRun() {
        HashCalcJobEx dep = (HashCalcJobEx)this.getDependency();
        this.hash = dep.produceHash();
        this.sha1 = dep.getSHA1();
        this.checkfile = new File(this.fecDataDir, this.hash);
        String dest = this.fecProgress.getProperty(this.hash);
        if (dest != null) {
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " FEC blocks for " + this.filename + " up to date.");
            this.fecProgress.setProperty(this.hash, this.fecToken);
            return false;
        }
        this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Starting FEC encoding for " + this.filename);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        FECConnection encoder = this.fc.getFECInstance();
        try {
            if (encoder == null) {
                this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Waiting until FEC encoder is free..");
                encoder = this.fc.waitForFECInstance();
            }
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Generating check chunks for " + this.filename);
            long now = System.currentTimeMillis();
            boolean okay = encoder.fecEncodeFile(this.file, this.checkfile, this.fecMetrics);
            long secs = (System.currentTimeMillis() - now) / 1000L;
            if (!okay) {
                this.ic.addlog("[Error] unexpected error while building check chunks!");
                int n = 2;
                return n;
            }
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " " + this.filename + ": Finished generating " + "check chunks (" + secs + " seconds for " + this.file.length() + " bytes)");
            this.fecProgress.setProperty(this.hash, this.fecToken);
        }
        finally {
            if (encoder != null) {
                encoder.releaseInstance();
            }
        }
        return 0;
    }

    public File produceFile() {
        return this.checkfile;
    }

    public String produceHash() {
        return this.hash;
    }

    public String getSHA1() {
        return this.sha1;
    }
}

