/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.MyLogger;
import fiw.core.ThreadCounter;
import fiw.core.jobs.Job;
import fiw.core.jobs.JobScheduler;
import fiw.core.jobs.ThreadProducer;

public class DefaultJobScheduler
implements JobScheduler {
    private Thread schedThread;
    private ThreadCounter myCounter;
    private boolean success = true;
    private boolean finished = false;
    private boolean criticalError = false;
    private boolean shouldStop = false;
    private ThreadProducer tp;
    protected Job[] jobs;
    protected Object syncJobs = new Object();
    private int currentJob = 0;

    public DefaultJobScheduler(Job[] jobs, int maxThreads, MyLogger l, ThreadProducer tp) {
        for (int i = 0; i < jobs.length; ++i) {
            Job[] deps = jobs[i].getDependencies();
            block1: for (int j = 0; j < deps.length; ++j) {
                for (int k = 0; k < i; ++k) {
                    if (jobs[k] == deps[j]) continue block1;
                }
                throw new IllegalArgumentException("Job " + deps[j] + " not scheduled before " + jobs[i]);
            }
        }
        this.myCounter = new ThreadCounter(maxThreads, l);
        this.jobs = jobs;
        this.tp = tp;
    }

    public void start() {
        this.schedThread = new Thread(){

            public void run() {
                DefaultJobScheduler.this.runScheduler();
            }
        };
        this.schedThread.start();
    }

    public void startAndWait() {
        this.runScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyFinished(Job j) {
        Object object = this.syncJobs;
        synchronized (object) {
            this.myCounter.releaseThread();
            this.syncJobs.notify();
        }
    }

    public void notifySkipping(Job j) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyError(boolean stopAll) {
        ThreadCounter threadCounter = this.myCounter;
        synchronized (threadCounter) {
            this.success = false;
            this.criticalError = stopAll;
        }
    }

    public synchronized void runAsThread(Job j) {
        this.tp.produceThread(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFinished() {
        ThreadCounter threadCounter = this.myCounter;
        synchronized (threadCounter) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        ThreadCounter threadCounter = this.myCounter;
        synchronized (threadCounter) {
            this.shouldStop = true;
        }
    }

    public void waitForFinished() {
        try {
            this.schedThread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean wasSuccessful() {
        ThreadCounter threadCounter = this.myCounter;
        synchronized (threadCounter) {
            return this.success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScheduler() {
        this.tp.initialize();
        try {
            int nextJob;
            while ((nextJob = this.getNextJob()) != -1) {
                ThreadCounter threadCounter = this.myCounter;
                synchronized (threadCounter) {
                    if (this.criticalError || this.shouldStop) {
                        break;
                    }
                    this.myCounter.startThread();
                }
                this.jobs[nextJob].start(this, nextJob + 1);
            }
            this.myCounter.waitForAllThreads();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.tp.finish();
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextJob() throws InterruptedException {
        if (this.currentJob >= this.jobs.length) {
            this.currentJob = -1;
        } else {
            Object object = this.syncJobs;
            synchronized (object) {
                while (!this.jobs[this.currentJob].isReadyToRun()) {
                    this.syncJobs.wait();
                }
            }
        }
        return this.currentJob++;
    }
}

