/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.ContentTypeManager;
import fiw.core.FIWSystem;
import fiw.core.SubFile;
import fiw.core.insert.FreenetContainer;
import fiw.core.insert.InsertContext;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataMaskProducing;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ContainerBuilderJob
extends Job
implements MetadataMaskProducing {
    private InsertContext ic;
    private FreenetContainer cont;
    private ContentTypeManager ctm;
    private String metadataMask = null;

    public ContainerBuilderJob(FreenetContainer cont, ContentTypeManager ctm, InsertContext ic, Job[] dependencies) {
        super(false, dependencies, "Building container " + cont.getName());
        this.cont = cont;
        this.ic = ic;
        this.ctm = ctm;
    }

    public int run() {
        List fls = this.cont.getFiles();
        StringBuffer mdInside = new StringBuffer();
        StringBuffer md = new StringBuffer();
        mdInside.append("Version\nRevision=1\n");
        Iterator i = fls.iterator();
        while (i.hasNext()) {
            SubFile fl = (SubFile)i.next();
            String common = "Name=" + fl.getSubName() + "\nInfo.Format=" + this.ctm.getCType(fl.getSubName()) + "\n";
            mdInside.append("EndPart\nDocument\n").append(common);
            md.append("EndPart\nDocument\n").append("Redirect.Target=#//").append(fl.getSubName()).append("\n").append(common);
            if (!fl.getSubName().equals("index.html")) continue;
            md.append("EndPart\nDocument\n").append("Redirect.Target=#//").append(fl.getSubName()).append("\nInfo.Format=").append(this.ctm.getCType(fl.getSubName())).append("\n");
        }
        mdInside.append("End\n");
        this.metadataMask = md.toString();
        this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Building container " + this.cont.getName());
        byte[] bs = new byte[8192];
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(this.cont.getContainerFile()));
            zos.setLevel(9);
            ZipEntry ze = new ZipEntry("manifest");
            ze.setTime(0L);
            zos.putNextEntry(ze);
            zos.write(mdInside.toString().getBytes("ISO-8859-1"));
            zos.closeEntry();
            Iterator i2 = fls.iterator();
            while (i2.hasNext()) {
                int length;
                SubFile fl = (SubFile)i2.next();
                ze = new ZipEntry(fl.getSubName());
                ze.setTime(0L);
                zos.putNextEntry(ze);
                FileInputStream bis = new FileInputStream(fl);
                while ((length = ((InputStream)bis).read(bs)) != -1) {
                    zos.write(bs, 0, length);
                }
                ((InputStream)bis).close();
                zos.closeEntry();
            }
            zos.finish();
            zos.close();
            long filelength = this.cont.getContainerFile().length();
            if (filelength >= (long)this.ic.FECMINSIZE) {
                this.ic.addlog("#" + InsertContext.num(this.myNumber) + " [Error] Container is too " + "large (" + filelength + " bytes): " + this.cont.getName());
                this.ic.setRetryFutile();
                return 3;
            }
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " Finished building container " + this.cont.getName());
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            ex.printStackTrace(FIWSystem.log());
            this.ic.addlog("#" + InsertContext.num(this.myNumber) + " [Error] Unexpected error - " + "consult logfile");
            this.ic.setRetryFutile();
            return 3;
        }
    }

    public String produceMetadataMask() {
        return this.metadataMask;
    }
}

