/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.jobs;

import fiw.core.insert.InsertContext;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataProducing;

public class CollisionFallbackJob
extends Job
implements MetadataProducing {
    private InsertContext ic;
    private MetadataProducing mapfile;

    public CollisionFallbackJob(MetadataProducing mapfile, InsertContext ic, Job[] dependencies) {
        super(false, dependencies, "collision fallback");
        this.ic = ic;
        this.mapfile = mapfile;
        for (int i = 0; i < dependencies.length; ++i) {
            ((InsertJob)dependencies[i]).setKeyCollisionOkay();
        }
    }

    public int run() {
        Job[] deps = this.getDependencies();
        boolean coll = false;
        for (int i = 0; i < deps.length; ++i) {
            if (!((InsertJob)deps[i]).isKeyCollision()) continue;
            coll = true;
            break;
        }
        if (!coll) {
            return 1;
        }
        this.ic.addlog("#" + InsertContext.num(this.myNumber) + " At least one mapfile could not " + "be inserted.");
        return 0;
    }

    public String produceMetadata() {
        String metadata = this.mapfile.produceMetadata();
        if (metadata == null) {
            this.ic.addlog("[Error] No metadata available for fallback key");
        }
        return metadata;
    }
}

