/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert.event;

import fiw.core.Stoppable;
import fiw.core.insert.InsertLogger;
import fiw.core.insert.event.InsertEvent;
import fiw.core.insert.event.InsertListener;
import java.util.HashMap;

public class InsertLoggerListener
implements InsertListener {
    public InsertLogger il;
    private HashMap jobNumbers = new HashMap();

    public InsertLoggerListener(InsertLogger il) {
        this.il = il;
    }

    public void insertProgressed(InsertEvent evt) {
        if (evt.isPartialLogString()) {
            this.il.addlogNoNewline(evt.toLogString());
        } else if (evt.toLogString() != null) {
            this.il.addlog(evt.toLogString());
        }
        int jno = evt.getJobNumber();
        if (jno != 0) {
            int no;
            if (evt.isJobStarted()) {
                if (this.jobNumbers.get(new Integer(jno)) != null) {
                    throw new RuntimeException("double job number");
                }
                no = this.il.addThread(jno);
                this.jobNumbers.put(new Integer(jno), new Integer(no));
            } else {
                if (this.jobNumbers.get(new Integer(jno)) == null) {
                    throw new RuntimeException("No job number for " + jno);
                }
                no = (Integer)this.jobNumbers.get(new Integer(jno));
                if (no == -2) {
                    throw new RuntimeException("Using zombie job " + jno);
                }
            }
            if (evt.toJobLogString() != null) {
                this.il.setThread(no, evt.toJobLogString());
            }
            if (evt.isJobEnded()) {
                this.il.removeThread(no);
                this.jobNumbers.put(new Integer(jno), new Integer(-2));
            }
        }
    }

    public void setStatus(String s) {
        this.il.setStatus(s);
    }

    public void restart() {
        this.jobNumbers.clear();
        this.il.restart();
    }

    public void iamhere(Stoppable ie) {
        this.il.iamhere(ie);
    }

    public void done() {
        this.il.done();
    }
}

