/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.ContentTypeManager;
import fiw.core.EnumerationIterator;
import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.GUIHelper;
import fiw.core.HTMLParser;
import fiw.core.Settings;
import fiw.core.StringSplitter;
import fiw.core.SubFile;
import fiw.core.insert.FileClass;
import fiw.core.insert.FreenetContainer;
import fiw.core.insert.InsertContext;
import fiw.core.insert.InsertController;
import fiw.core.insert.Insertable;
import fiw.core.insert.InsertableFile;
import fiw.core.jobs.CollisionFallbackJob;
import fiw.core.jobs.ContainerBuilderJob;
import fiw.core.jobs.DBRInsertJob;
import fiw.core.jobs.DummyJob;
import fiw.core.jobs.FECBuilderJob;
import fiw.core.jobs.FileInsertJob;
import fiw.core.jobs.FilePartInsertJob;
import fiw.core.jobs.HashCalcJob;
import fiw.core.jobs.HashCalcJobEx;
import fiw.core.jobs.IndirectMapfileInsertJob;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MapfileBuilderJob;
import fiw.core.jobs.MetadataInsertJob;
import fiw.core.jobs.MetadataMaskFillerJob;
import fiw.core.jobs.SplitFileInsertJob;
import fiw.core.jobs.SplitfileBuilderJob;
import fiw.fcp.FECConnection;
import fiw.fcp.FECMetrics;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ProjectInsertController
extends InsertController {
    private int project;
    private boolean clearProgress;
    private boolean useParser;
    private boolean noRealInsert;
    private List insertables = null;
    private FileClass[] fileClasses = null;
    private Thread myThread;
    private File basedir;
    private File metadir;
    private Settings ss;
    private boolean isDBR;
    private boolean fecNeeded = false;
    private InsertJob resultKeyJob = null;
    private InsertJob testResultKeyJob = null;
    private static final Job[] NO_DEPS = new Job[0];

    public ProjectInsertController(InsertContext ic, int project, boolean clearProgress, boolean useParser, boolean noRealInsert) {
        super(ic);
        this.project = project;
        this.clearProgress = clearProgress;
        this.useParser = useParser;
        this.noRealInsert = noRealInsert;
        this.ss = FIWSystem.setts();
        this.basedir = this.ss.getProjectFile(project);
        this.metadir = FileUtil.fiwDir(this.basedir);
        this.isDBR = this.ss.getProjectSetting(project, "dbr").equals("true");
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public boolean insert() {
        boolean fail;
        if (!this.greetAndCheck()) {
            return false;
        }
        File progressFile = new File(this.metadir, this.ic.testinsert ? "testprogress.ini" : "progress.ini");
        if (!this.ic.loadProgress(progressFile, this.clearProgress)) {
            this.ic.setRetryFutile();
            return false;
        }
        this.ic.addlog("*** Loading mimetype.conf...");
        String htmlCharset = this.ss.getProjectSettingDef(this.project, "charset", "");
        ContentTypeManager ctm = null;
        try {
            ctm = new ContentTypeManager(htmlCharset);
        }
        catch (FileNotFoundException ex) {
            this.ic.addlog("[Error] Unable to load mimetype.conf.");
            return false;
        }
        File parseFile = new File(this.metadir, "parse.ini");
        HTMLParser hp = null;
        if (parseFile.exists()) {
            if (this.useParser) {
                hp = new HTMLParser(this.project, this.ic.testinsertmod, this.ic.getMyLogger());
                this.ic.addlog("*** parsing files...");
                hp.parseAll();
                if (hp.getErrors()) {
                    this.ic.addlog("--- failed parsing.");
                    return false;
                }
                this.ic.addlog("--- finished parsing.");
                this.useParser = false;
            }
        } else {
            parseFile = null;
        }
        if (!this.readFileClasses(parseFile)) {
            return false;
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        String prepMap = this.getPreparedMapfileEntries(ctm);
        if (prepMap == null) {
            return false;
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        this.ic.addlog("*** Searching files...");
        this.fecNeeded = false;
        Properties fecsettings = new Properties();
        String fecToken = FileUtil.dateString();
        File fecDataDir = new File(this.metadir, "fecdata");
        File fecsetf = new File(this.metadir, "fec.ini");
        if (fecsetf.exists()) {
            if (!FileUtil.loadProperties(fecsettings, fecsetf)) {
                this.ic.addlog("[Error] Unexpected error - consult logfile");
                return false;
            }
            fecsettings.setProperty("Version", "2");
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        if (!this.parseFiles(fecsettings, ctm.getIgnoredFileNames())) {
            return false;
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        if (this.fecNeeded && !this.buildFECMetrics(fecDataDir)) {
            return false;
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        this.resultKeyJob = null;
        this.testResultKeyJob = null;
        Job[] jobs = this.buildJobs(fecsettings, fecToken, fecDataDir, ctm, prepMap);
        if (jobs == null) {
            return false;
        }
        this.ic.newChanceForUnreachable();
        boolean bl = fail = !this.runJobList(jobs);
        if (this.ic.shouldStop()) {
            return false;
        }
        if (this.fecNeeded && !fail) {
            this.fecCleanup(fecsettings, fecsetf, fecDataDir, fecToken);
        }
        if (this.ic.shouldStop()) {
            return false;
        }
        if (this.ic.isAllUnreachable()) {
            this.ic.addlog("[Warning] Some of your requests could not even make it off your node. Please check your Internet connection.");
        }
        if (fail) {
            this.ic.addlog("\n+++ FAILED +++");
            return false;
        }
        if (this.noRealInsert) {
            this.ic.addlog("\n+++ FINISHED +++ (you selected to stop before inserting files)");
            return true;
        }
        this.ic.addlog("\n+++ FINISHED +++");
        if (this.ic.testinsert) {
            this.ic.addlog("***  Now you can test your freesite locally.");
        } else {
            this.ic.addlog("*** Now you have to propagate your URI (e.g. send it to TFE).\n    Another good idea would be asking the guys in #freenet on IIP\n    (http://www.invisiblenet.net/iip/) if they can get your \n    freesite (as requesting it helps propagating it).");
        }
        if (this.testResultKeyJob != null && this.testResultKeyJob.getResultKey() != null) {
            this.resultKeyJob = this.testResultKeyJob;
        }
        this.ic.addlog("\nYour URI:\n\n" + this.resultKeyJob.getResultKey() + "//\n\nHave fun!\n\n");
        return true;
    }

    private boolean greetAndCheck() {
        this.ic.addlog("=*======== Inserting project (FIW 0.08) ========*=\nName: " + this.ss.getProjectSetting(this.project, "name") + "\n" + "HTL: " + this.ic.htl + "\n" + (this.isDBR ? "  First slot: " + GUIHelper.getInstance().getDateString((long)Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.first")) * 1000L) + "\n" + "  Last slot:  " + GUIHelper.getInstance().getDateString((long)Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.last")) * 1000L) + "\n" : "  Edition: " + this.ss.getProjectSetting(this.project, "editionx") + "\n") + "Public URI: " + this.ss.getPublicURI(this.project, this.ic.testinsertmod, 0) + "//\n" + "Start of insert: " + FileUtil.dateString2() + "\n" + "FCP host/port: " + this.fc.getHost() + ":" + this.fc.getPort() + "\n" + (this.ic.testinsert ? "[Test insert]\n" : "") + (this.noRealInsert ? "[Only preparations]\n" : "") + "=*==============================================*=\n\n");
        if (this.ic.shouldStop()) {
            return false;
        }
        if (!this.basedir.exists()) {
            this.ic.addlog("[Error] Directory does not exist.");
            this.ic.setRetryFutile();
            return false;
        }
        if (this.useParser && new File(this.basedir, "__index.html").exists()) {
            this.ic.addlog("[Error] __index.html not supported any more.");
            return false;
        }
        if (this.useParser && new File(this.basedir, "__mapfile").exists()) {
            this.ic.addlog("[Error] __mapfile not supported any more.");
            return false;
        }
        this.ic.addlog("*** Performing general checks:");
        boolean testsok = FIWSystem.setts().doTest(this.ic.getFCPConnection(), this.project, this.ic.getMyLogger());
        if (!testsok) {
            this.ic.addlog("[Error] Checks failed. Stopping.");
            return false;
        }
        this.ic.addlog("--- All checks finished.\n");
        return true;
    }

    private String getPreparedMapfileEntries(ContentTypeManager ctm) {
        if (new File(this.metadir, "mapfile.ini").exists()) {
            StringBuffer prepmap = new StringBuffer();
            this.ic.addlog("*** Reading mapfile.ini...");
            Properties mf = FileUtil.loadMapFile(this.basedir);
            if (mf == null) {
                this.ic.addlog("[Error] Could not load mapfile.ini");
                return null;
            }
            EnumerationIterator it = new EnumerationIterator(mf.propertyNames());
            while (it.hasNext()) {
                String filename = (String)it.next();
                String fileCHK = mf.getProperty(filename);
                int posi = filename.indexOf(35);
                if (posi != -1) {
                    prepmap.append("EndPart\nDocument\nRedirect.Target=freenet:" + fileCHK + "\nName=" + filename.substring(0, posi) + "\nInfo.Format=" + ctm.parseEncoding(filename.substring(posi + 1)) + "\n");
                    continue;
                }
                String ct = ctm.getCType(filename);
                prepmap.append("EndPart\nDocument\nRedirect.Target=freenet:" + fileCHK + "\nName=" + filename + "\nInfo.Format=" + ct + "\n");
            }
            this.ic.addlog("*** Read mapfile.ini");
            return prepmap.toString();
        }
        return "";
    }

    private FileClass getFileClass(String name) {
        for (int j = 0; j < this.fileClasses.length; ++j) {
            if (!this.fileClasses[j].matchesFile(name)) continue;
            return this.fileClasses[j];
        }
        throw new RuntimeException("Bug somewhere in FileClass");
    }

    private boolean parseFiles(Properties fecsettings, List ignfiles) {
        SubFile[] fl = SubFile.listSubFiles(this.basedir, ignfiles);
        for (int i = 0; i < fl.length; ++i) {
            String name = fl[i].getSubName();
            if (fl[i].isDirectory()) {
                this.ic.addlog("[Warning] Ignoring directory " + name);
                continue;
            }
            boolean useFEC = false;
            String prop = fecsettings.getProperty("usefec." + fl[i].getName());
            if ("yes".equals(prop) || "true".equals(prop)) {
                useFEC = true;
            } else if (!"no".equals(prop) && !"false".equals(prop) && fl[i].length() >= (long)this.ic.FECMINSIZE) {
                useFEC = true;
                for (int j = 0; j < this.ic.NOFECEXTS.length; ++j) {
                    if (!fl[i].getName().endsWith(this.ic.NOFECEXTS[j])) continue;
                    useFEC = false;
                }
            }
            FileClass fc = this.getFileClass(name);
            if (fc.isContainer()) {
                if (useFEC) {
                    this.ic.addlog("[Error] cannot put FEC file " + name + " into a container!");
                    return false;
                }
                fc.getContainer().addFile(fl[i]);
                continue;
            }
            if (useFEC && this.ic.testinsert && this.ic.TESTNOFEC) {
                this.ic.addlog("*** Skipping FEC file " + fl[i].getSubName());
                continue;
            }
            this.insertables.add(new InsertableFile(fl[i], fc.getPriority(), useFEC));
            if (!useFEC) continue;
            this.fecNeeded = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildFECMetrics(File fecDataDir) {
        if (!fecDataDir.exists()) {
            fecDataDir.mkdir();
        }
        FECConnection encoder = this.fc.getFECInstance();
        try {
            if (encoder == null) {
                this.ic.addlog("*** waiting until FEC encoder is free..");
                encoder = this.fc.waitForFECInstance();
            }
            this.ic.addlog("*** Generating FEC metrics for all files... ");
            Iterator it = this.insertables.iterator();
            while (it.hasNext()) {
                InsertableFile insf;
                Insertable ins = (Insertable)it.next();
                if (!(ins instanceof InsertableFile) || !(insf = (InsertableFile)ins).getUseFEC()) continue;
                FECMetrics fecm = encoder.getFECMetrics(insf.getFile().length());
                if (fecm == null) {
                    this.ic.addlog("[Error] Unexpected error while calculating FEC metrics");
                    boolean bl = false;
                    return bl;
                }
                insf.setFECMetrics(fecm);
            }
            this.ic.addlog("--- FEC metric generation finished.");
        }
        finally {
            if (encoder != null) {
                encoder.releaseInstance();
            }
        }
        return true;
    }

    private boolean readFileClasses(File parseFile) {
        ArrayList<FileClass> classes = new ArrayList<FileClass>();
        this.insertables = new ArrayList();
        if (parseFile != null) {
            try {
                String line;
                this.ic.addlog("*** Reading file classes");
                BufferedReader br = new BufferedReader(new FileReader(parseFile));
                while ((line = br.readLine()) != null) {
                    int numdest;
                    if (!line.startsWith(":")) continue;
                    String[] parts = StringSplitter.split(line.substring(1), ":");
                    if (parts.length != 3) {
                        this.ic.addlog("[Error] Cannot parse \"" + line + "\"");
                        return false;
                    }
                    String type = parts[0];
                    String match = parts[1];
                    String destination = parts[2];
                    FreenetContainer container = null;
                    try {
                        numdest = Integer.parseInt(destination);
                        if (numdest < 0) {
                            numdest = -1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        numdest = -1;
                    }
                    if (numdest == -1) {
                        Iterator it = this.insertables.iterator();
                        while (it.hasNext()) {
                            Insertable elem = (Insertable)it.next();
                            if (!(elem instanceof FreenetContainer) || !((FreenetContainer)elem).getName().equals(destination)) continue;
                            container = (FreenetContainer)elem;
                            numdest = container.getPriority();
                            break;
                        }
                        if (numdest == -1) {
                            this.ic.addlog("[Error] Unknown container: " + destination);
                            return false;
                        }
                    }
                    if (type.equals("containerphantom")) {
                        if (container != null) {
                            this.ic.addlog("[Error] Containers inside containers are not supported");
                            return false;
                        }
                        this.insertables.add(new FreenetContainer(numdest, match, false, new File(this.metadir, match)));
                        continue;
                    }
                    if (type.equals("container")) {
                        if (container != null) {
                            this.ic.addlog("[Error] Containers inside containers are not supported");
                            return false;
                        }
                        this.insertables.add(new FreenetContainer(numdest, match, true, new File(this.metadir, match)));
                        continue;
                    }
                    if (type.equals("exact")) {
                        classes.add(new FileClass(0, match, numdest, container));
                        continue;
                    }
                    if (type.equals("ending")) {
                        classes.add(new FileClass(1, match, numdest, container));
                        continue;
                    }
                    if (type.equals("regex")) {
                        classes.add(new FileClass(2, match, numdest, container));
                        continue;
                    }
                    this.ic.addlog("[Error] Cannot parse \"" + line + "\"");
                    return false;
                }
                br.close();
                this.ic.addlog("*** Finished reading file classes");
            }
            catch (IOException e) {
                this.ic.addlog("[Error] internal error, consult logfile");
                e.printStackTrace();
                e.printStackTrace(FIWSystem.log());
                return false;
            }
        }
        classes.add(new FileClass(1, "", this.ic.DEFAULT_PRIORITY, null));
        this.fileClasses = classes.toArray(new FileClass[classes.size()]);
        return true;
    }

    private Job[] buildJobs(Properties fecsettings, String fecToken, File fecDataDir, ContentTypeManager ctm, String prepMap) {
        ArrayList<Job> firstpass = new ArrayList<Job>();
        ArrayList<SplitFileInsertJob> splitfiles = new ArrayList<SplitFileInsertJob>();
        ArrayList<Job> secondpass = new ArrayList<Job>();
        ArrayList<InsertJob> toVerify = new ArrayList<InsertJob>();
        ArrayList<Job> mapfileNeeded = new ArrayList<Job>();
        this.ic.addlog("*** building job tree");
        Object[] insis = this.insertables.toArray(new Insertable[this.insertables.size()]);
        Arrays.sort(insis);
        int increment = 0;
        if (this.isDBR && !this.noRealInsert) {
            increment = Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.increment"));
            int offset = Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.offset"));
            String key = this.ss.getPrivateURI(this.project, this.ic.testinsertmod);
            String pubkey = this.ss.getPublicURI(this.project, this.ic.testinsertmod, -1);
            DBRInsertJob j = new DBRInsertJob(key, increment, offset, pubkey, this.ic, NO_DEPS);
            if (this.ic.NODBRMISMATCH) {
                j.setKeyCollisionOkay();
            } else {
                j.setKeyCollisionWarning("[Error] Your current DBR and the DBR already available are different.\n        If you used another software for uploading them, add \n\n        tuning.nodbrmismatch=true\n\n        to your fiw.conf.");
            }
            firstpass.add(j);
            toVerify.add(j);
            this.resultKeyJob = j;
        }
        for (int i = 0; i < insis.length; ++i) {
            String filename;
            Object in = insis[i];
            if (in instanceof FreenetContainer) {
                FreenetContainer inc = (FreenetContainer)in;
                filename = inc.getContainerFile().getName();
                ContainerBuilderJob bj = new ContainerBuilderJob(inc, ctm, this.ic, NO_DEPS);
                firstpass.add(bj);
                if (this.noRealInsert) continue;
                HashCalcJob hj = new HashCalcJob(inc.getContainerFile(), filename, this.ic, NO_DEPS);
                String metadata = "Version\nRevision=1\nEndPart\nDocument\nInfo.Format=application/zip\nEnd\n" + (this.ic.modifyMetadata ? "Comment=FIW_Test\n" : "");
                FileInsertJob fj = new FileInsertJob(inc.getContainerFile(), filename, null, null, false, "CHK@", metadata, this.ic, new Job[]{hj});
                firstpass.add(hj);
                firstpass.add(fj);
                if (inc.isInsertedAsFile()) {
                    mapfileNeeded.add(fj);
                }
                MetadataMaskFillerJob mmf = new MetadataMaskFillerJob(bj, fj, this.ic, new Job[]{bj, fj});
                firstpass.add(mmf);
                mapfileNeeded.add(mmf);
                if (((Insertable)in).getPriority() < 10) {
                    toVerify.add(fj);
                    continue;
                }
                fj.setCalcOnly();
                FileInsertJob fj2 = new FileInsertJob(inc.getContainerFile(), filename, null, null, false, "CHk@", metadata, this.ic, new Job[]{hj});
                secondpass.add(fj2);
                toVerify.add(fj2);
                continue;
            }
            if (in instanceof InsertableFile) {
                InsertableFile inf = (InsertableFile)in;
                filename = inf.getFile().getSubName();
                if (inf.getUseFEC()) {
                    int[] metrics = inf.getFECMetrics().getLegacyFECMetrics();
                    boolean wasZero = false;
                    long accu = 0L;
                    int cnt = 0;
                    ArrayList<Job> partJobs = new ArrayList<Job>();
                    FECBuilderJob fecBuilder = null;
                    HashCalcJobEx hj = new HashCalcJobEx(inf.getFile(), filename, this.ic, NO_DEPS);
                    firstpass.add(hj);
                    for (int j = 0; j < metrics.length; ++j) {
                        ++cnt;
                        if (metrics[j] == 0) {
                            cnt = 0;
                            accu = 0L;
                            wasZero = true;
                            fecBuilder = new FECBuilderJob(inf.getFile(), filename, fecsettings, fecToken, fecDataDir, inf.getFECMetrics(), this.ic, new Job[]{hj});
                            firstpass.add(fecBuilder);
                            continue;
                        }
                        if (this.noRealInsert) {
                            if (!wasZero) continue;
                            break;
                        }
                        FilePartInsertJob jjj = wasZero ? new FilePartInsertJob(null, filename, accu, (long)metrics[j], cnt, true, this.ic, new Job[]{fecBuilder}) : new FilePartInsertJob(inf.getFile(), filename, accu, (long)metrics[j], cnt, false, this.ic, new Job[]{hj});
                        accu += (long)metrics[j];
                        partJobs.add(jjj);
                        firstpass.add(jjj);
                        if (inf.getPriority() < 10) {
                            toVerify.add(jjj);
                            continue;
                        }
                        jjj.setCalcOnly();
                        FilePartInsertJob jjj2 = new FilePartInsertJob(jjj);
                        secondpass.add(jjj2);
                        toVerify.add(jjj2);
                    }
                    if (this.noRealInsert) continue;
                    partJobs.add(0, fecBuilder);
                    Job[] pJobs = partJobs.toArray(new Job[partJobs.size()]);
                    SplitfileBuilderJob fc = new SplitfileBuilderJob(inf.getFile().length(), filename, ctm.getCType(filename), this.ic, pJobs);
                    firstpass.add(fc);
                    SplitFileInsertJob fci = new SplitFileInsertJob("CHK@", filename, ctm.getCType(filename), filename.equals("index.html"), this.ic, new Job[]{fc});
                    splitfiles.add(fci);
                    mapfileNeeded.add(fci);
                    if (inf.getPriority() < 10) {
                        toVerify.add(fci);
                        continue;
                    }
                    fci.setCalcOnly();
                    SplitFileInsertJob fci2 = new SplitFileInsertJob("CHK@", filename, ctm.getCType(filename), filename.equals("index.html"), this.ic, new Job[]{fc});
                    secondpass.add(fci2);
                    toVerify.add(fci2);
                    continue;
                }
                if (this.noRealInsert) continue;
                HashCalcJob hj = new HashCalcJob(inf.getFile(), filename, this.ic, NO_DEPS);
                FileInsertJob fj = new FileInsertJob(inf.getFile(), filename, ctm.getCType(filename), null, filename.equals("index.html"), this.ic.modifyMetadata, this.ic, new Job[]{hj});
                firstpass.add(hj);
                firstpass.add(fj);
                mapfileNeeded.add(fj);
                if (inf.getPriority() < 10) {
                    toVerify.add(fj);
                    continue;
                }
                fj.setCalcOnly();
                FileInsertJob fj2 = new FileInsertJob(inf.getFile(), filename, ctm.getCType(filename), null, filename.equals("index.html"), this.ic.modifyMetadata, this.ic, new Job[]{hj});
                secondpass.add(fj2);
                toVerify.add(fj2);
                continue;
            }
            this.ic.addlog("[Error] Internal error: cannot handle " + in.getClass().getName());
            return null;
        }
        firstpass.addAll(splitfiles);
        if (this.ic.shouldStop()) {
            return null;
        }
        if (!this.noRealInsert) {
            String extra = "";
            if (!"0".equals(this.ss.getProjectSetting(this.project, "editionx"))) {
                this.ic.addlog("    (Adding .next link to mapfile)");
                extra = extra + "EndPart\nDocument\nRedirect.Target=freenet:" + this.ss.getPublicURI(this.project, this.ic.testinsertmod, 1) + "\n" + "Name=.next\nInfo.Format=" + ctm.parseEncoding("text/html") + "\n";
            }
            if (prepMap.length() > 0) {
                this.ic.addlog("    (Adding mapfile.ini entries to mapfile)");
                extra = extra + prepMap;
            }
            MapfileBuilderJob mfj2 = new MapfileBuilderJob(extra, this.ic, mapfileNeeded.toArray(new Job[mapfileNeeded.size()]));
            firstpass.add(mfj2);
            IndirectMapfileInsertJob mfj = new IndirectMapfileInsertJob(this.ic, true, new Job[]{mfj2});
            firstpass.add(mfj);
            if (this.getFileClass("indirect.mapfile").getPriority() < 10) {
                toVerify.add(mfj);
            } else {
                IndirectMapfileInsertJob mfj3 = new IndirectMapfileInsertJob(this.ic, false, new Job[]{mfj2});
                mfj.setCalcOnly();
                firstpass.add(mfj3);
                toVerify.add(mfj3);
            }
            ArrayList<MetadataInsertJob> mapfileJobs = new ArrayList<MetadataInsertJob>();
            if (this.isDBR) {
                int fromslot = Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.first"));
                int toslot = Integer.parseInt(this.ss.getProjectSetting(this.project, "dbr.last"));
                for (int slot = fromslot; slot <= toslot; slot += increment) {
                    String key = this.ss.getPrivateURI(this.project, this.ic.testinsertmod, slot);
                    String title = "slot [" + GUIHelper.getInstance().getDateString((long)slot * 1000L) + "]";
                    MetadataInsertJob j = new MetadataInsertJob(key, null, title, this.ic, new Job[]{mfj});
                    firstpass.add(j);
                    toVerify.add(j);
                    mapfileJobs.add(j);
                }
                this.ic.addlog("*** To test DBRs, use the `?date=yyyymmdd-hh:mm:ss' parameter");
            } else {
                String key = this.ss.getPrivateURI(this.project, this.ic.testinsertmod);
                MetadataInsertJob j2 = new MetadataInsertJob(key, null, "mapfile", this.ic, new Job[]{mfj});
                firstpass.add(j2);
                toVerify.add(j2);
                this.resultKeyJob = j2;
                mapfileJobs.add(j2);
            }
            if (this.ic.testinsert) {
                Job[] allmapfiles = mapfileJobs.toArray(new Job[mapfileJobs.size()]);
                CollisionFallbackJob coll = new CollisionFallbackJob(mfj, this.ic, allmapfiles);
                firstpass.add(coll);
                this.testResultKeyJob = new MetadataInsertJob("CHK@", null, "CHK mapfile", this.ic, new Job[]{coll});
                firstpass.add(this.testResultKeyJob);
                toVerify.add(this.testResultKeyJob);
            }
            if (this.ic.doVerify(true)) {
                DummyJob dj = new DummyJob("=============================\nFetching inserted data again:", this.ic, toVerify.toArray(new Job[toVerify.size()]));
                secondpass.add(dj);
                Iterator it = toVerify.iterator();
                while (it.hasNext()) {
                    InsertJob j = (InsertJob)it.next();
                    secondpass.add(j.buildChecker(true, null, dj));
                }
            }
        }
        firstpass.addAll(secondpass);
        return firstpass.toArray(new Job[firstpass.size()]);
    }

    private void fecCleanup(Properties fecsettings, File fecsetf, File fecDataDir, String fecToken) {
        Iterator<Object> iter = fecsettings.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String name = (String)iter.next();
            if ("Version".equals(name) || name.startsWith("usefec.") || fecToken.equals(value = fecsettings.getProperty(name))) continue;
            this.ic.addlog("*** Deleting FEC cache file " + name);
            new File(fecDataDir, name).delete();
            iter.remove();
        }
        FileUtil.saveProperties(fecsettings, fecsetf, "FEC settings cache");
    }
}

