/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.FIWSystem;
import fiw.core.insert.FileInsertController;
import fiw.core.insert.InsertContext;
import fiw.core.insert.ProjectInsertController;
import fiw.core.insert.ToFileInsertLogger;
import fiw.core.insert.event.InsertListener;
import fiw.core.insert.event.InsertLoggerListener;
import fiw.fcp.FCPConnection;
import java.io.File;

public class InsertEngine {
    InsertContext ic;

    private InsertEngine(FCPConnection fc, int htl, InsertListener listener, String xtra) {
        this(fc, htl, listener, xtra, false, false);
    }

    private InsertEngine(FCPConnection fc, int htl, InsertListener listener, String xtra, boolean isProject, boolean testinsert) {
        if (htl < 0) {
            htl = 0;
        }
        this.ic = new InsertContext(fc, testinsert, isProject, htl);
        this.ic.addInsertListener(listener);
        ToFileInsertLogger l = new ToFileInsertLogger(xtra);
        this.ic.addInsertListener(new InsertLoggerListener(l));
        this.ic.addlog(l.getLoggerState());
    }

    public InsertEngine(FCPConnection fc, int project, int htl, boolean clearprogress, boolean useParser, InsertListener listener) {
        this(fc, htl, listener, FIWSystem.setts().getProjectSetting(project, "keydir") + "-" + (htl == -1 ? "test-" : (htl == -2 ? "fecmake-" : "")), true, htl == -1);
        new ProjectInsertController(this.ic, project, clearprogress, useParser, htl == -2);
    }

    public InsertEngine(FCPConnection fc, int htl, boolean adv, String key, String ctype, File file, InsertListener listener) {
        this(fc, htl, listener, "file-");
        new FileInsertController(this.ic, key, adv, ctype, file);
    }

    public InsertEngine(FCPConnection fc, int htl, boolean adv, String key, String metadata, InsertListener listener) {
        this(fc, htl, listener, "metadata-");
        new FileInsertController(this.ic, key, adv, metadata);
    }
}

