/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.FIWSystem;
import fiw.core.I18n;
import fiw.core.Stoppable;
import fiw.core.insert.InsertContext;
import fiw.core.jobs.Job;
import fiw.core.jobs.JobScheduler;
import fiw.core.jobs.PooledThreadProducer;
import fiw.core.jobs.ReorderingJobScheduler;
import fiw.core.jobs.SimpleThreadProducer;
import fiw.core.jobs.ThreadProducer;
import fiw.fcp.FCPConnection;

public abstract class InsertController
implements Runnable,
Stoppable {
    protected InsertContext ic;
    protected FCPConnection fc;
    private boolean failure = false;
    private Thread sleeping = null;
    private JobScheduler js;
    private static final boolean USE_DEBUGGING_FRIENDLY_SCHEDULER = false;

    public InsertController(InsertContext ic) {
        this.ic = ic;
        this.fc = ic.getFCPConnection();
    }

    public void run() {
        this.ic.fireIAmHere(this);
        int retry = 0;
        while (!this.ic.shouldStop()) {
            this.failure = false;
            this.ic.fireRestart();
            if (this.insert()) {
                this.ic.fireSetStatus(I18n.get("Finished_Insertion"));
                break;
            }
            this.ic.fireSetStatus(I18n.get("Stopped_Insertion"));
            if (!this.failure || this.ic.isRetryFutile() || this.ic.shouldStop()) break;
            this.ic.addlog("\n\n ******* Retrying insert in 1 minute *******\n\n");
            this.ic.fireSetStatus(I18n.get("RetryStopInsert"));
            this.sleeping = Thread.currentThread();
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sleeping = null;
            this.ic.fireSetStatus(I18n.format("RetryInsert", new Integer(++retry)));
        }
        if (this.ic.shouldStop()) {
            this.ic.addlog("+++ Aborted +++ ");
            this.ic.fireSetStatus(I18n.get("StatusAborted"));
        }
        this.ic.fireDone();
    }

    public synchronized void stopRunning() {
        this.ic.doStop();
        if (this.js != null) {
            this.js.doStop();
        }
        if (this.sleeping != null) {
            this.sleeping.interrupt();
        }
        this.ic.addlog("========= will try to abort... =========");
        this.ic.fireSetStatus(I18n.get("StatusAborting"));
    }

    protected void reportFailure() {
        this.failure = true;
    }

    protected boolean hasFailed() {
        return this.failure;
    }

    protected boolean runJobList(Job[] jobs) {
        this.ic.addlog("*** Processing " + jobs.length + " jobs...");
        int waittime = Integer.parseInt(FIWSystem.setts().getProperty("tuning.threadwait"));
        ThreadProducer tp = waittime == -1 ? new SimpleThreadProducer() : new PooledThreadProducer((long)waittime * 1000L);
        this.js = new ReorderingJobScheduler(jobs, this.ic.THREADS, this.ic.getMyLogger(), tp);
        this.js.startAndWait();
        if (!this.js.wasSuccessful()) {
            this.reportFailure();
            this.js = null;
            return false;
        }
        this.js = null;
        return true;
    }

    public abstract boolean insert();
}

