/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.MyLogger;
import fiw.core.Settings;
import fiw.core.Stoppable;
import fiw.core.insert.InsertListenerLogger;
import fiw.core.insert.event.InfoInsertEvent;
import fiw.core.insert.event.InsertEvent;
import fiw.core.insert.event.InsertListener;
import fiw.core.insert.event.StructuredJobInsertEvent;
import fiw.fcp.FCPConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class InsertContext {
    public static final String[] ACTIONS = new String[]{"Start      ", null, null, "Getting    ", "   Got     ", null, "***RouteNF ", "***DataNF  ", "Done          ", null, null, "Failed        ", "Examining  ", "Identical  ", "Different  ", "Aborted       ", null, "Checking   ", "CalcCHK    ", "Finished   "};
    public static final int AC_START = 0;
    public static final int AC_GETTING = 3;
    public static final int TAC_GETTING = 3;
    public static final int AC_GOT = 4;
    public static final int AC_RNF = 6;
    public static final int AC_DNF = 7;
    public static final int TAC_WIDE_DONE = 8;
    public static final int TAC_FAILED = 11;
    public static final int AC_EXAM = 12;
    public static final int AC_IDENT = 13;
    public static final int AC_DIFF = 14;
    public static final int TAC_WIDE_ABORTED = 15;
    public static final int TAC_START = 0;
    public static final int AC_CHECK = 17;
    public static final int AC_CALCCHK = 18;
    public static final int TAC_CALCCHK = 18;
    public static final int AC_FINISHED = 19;
    private MyLogger myLogger = new InsertListenerLogger(this);
    public boolean testinsert;
    public boolean testinsertmod;
    public boolean modifyMetadata;
    private boolean isProject;
    public boolean verify;
    public int htl;
    public int fetchHTL;
    public final int RETRIEVERETRY = InsertContext.loadInt("tuning.fetchtry");
    public final int HTLINC;
    public final int INSERTRETRY = InsertContext.loadInt("tuning.inserttry");
    public final int FECMINSIZE;
    public final int THREADS;
    public final int MAXNIMSIZE;
    public final int DEFAULT_PRIORITY;
    public final boolean VERIFY;
    public final boolean VERIFYTEST;
    public final boolean CHECKPROGRESS;
    public final boolean MODIFYTEST;
    public final boolean TESTNOFEC;
    public final boolean MODIFYURL;
    public final boolean NODBRMISMATCH;
    public final String[] NOFECEXTS;
    public final String VERIFYFLAGS;
    private boolean shouldStop;
    private boolean retryFutile;
    public List listeners;
    private int allUnreachable;
    private static final int UNREACHABLE_LIMIT = 10;
    File progressFile;
    Properties progress;
    private FCPConnection fcpConn;

    public InsertContext(FCPConnection fcpconn, boolean testinsert, boolean isProject, int htl) {
        this(fcpconn, testinsert, isProject, htl, -1);
    }

    public InsertContext(FCPConnection fcpconn, boolean testinsert, boolean isProject, int htl, int fetchHTL) {
        this.HTLINC = InsertContext.loadInt("tuning.htlinc");
        this.THREADS = InsertContext.loadInt("tuning.threadcount");
        this.FECMINSIZE = InsertContext.loadInt("tuning.fecminsize");
        this.MAXNIMSIZE = InsertContext.loadInt("tuning.maxnimsize");
        this.CHECKPROGRESS = InsertContext.loadBool("tuning.checkprogressfile");
        this.VERIFY = InsertContext.loadBool("tuning.doverify");
        this.VERIFYTEST = InsertContext.loadBool("tuning.doverifytest");
        this.MODIFYTEST = InsertContext.loadBool("tuning.modifytest");
        this.MODIFYURL = InsertContext.loadBool("tuning.modifyurl");
        this.TESTNOFEC = InsertContext.loadBool("tuning.testnofec");
        this.NODBRMISMATCH = InsertContext.loadBool("tuning.nodbrmismatch");
        this.VERIFYFLAGS = FIWSystem.setts().getProperty("tuning.verifyflags");
        String nfe = FIWSystem.setts().getProperty("tuning.nofecexts");
        StringTokenizer nfet = new StringTokenizer(nfe);
        this.NOFECEXTS = new String[nfet.countTokens()];
        for (int i = 0; i < this.NOFECEXTS.length; ++i) {
            String nto = nfet.nextToken();
            if (!nto.startsWith(".")) {
                nto = "." + nto;
            }
            this.NOFECEXTS[i] = nto;
        }
        this.DEFAULT_PRIORITY = InsertContext.loadInt("tuning.priority");
        this.shouldStop = false;
        this.retryFutile = false;
        this.listeners = new ArrayList();
        this.allUnreachable = 0;
        this.progressFile = null;
        this.progress = new Properties();
        this.fcpConn = fcpconn;
        this.testinsert = testinsert;
        this.testinsertmod = testinsert && this.MODIFYURL;
        this.isProject = isProject;
        this.verify = testinsert ? this.VERIFYTEST : this.VERIFY;
        this.htl = htl;
        this.fetchHTL = fetchHTL == -1 ? (htl == 0 ? htl : htl + this.HTLINC) : fetchHTL;
        if (testinsert && this.MODIFYTEST) {
            this.modifyMetadata = true;
        }
    }

    public boolean isTestInsert() {
        return this.testinsert;
    }

    public MyLogger getMyLogger() {
        return this.myLogger;
    }

    public boolean doVerify(boolean atend) {
        if (!this.verify) {
            return false;
        }
        return '1' == this.VERIFYFLAGS.charAt((this.testinsert ? 4 : 0) + (!this.isProject ? 2 : 0) + (atend ? 1 : 0));
    }

    private static int loadInt(String prop) {
        return Integer.parseInt(FIWSystem.setts().getProperty(prop));
    }

    private static boolean loadBool(String prop) {
        return "true".equals(FIWSystem.setts().getProperty(prop));
    }

    public synchronized boolean shouldStop() {
        return this.shouldStop;
    }

    public synchronized void doStop() {
        this.shouldStop = true;
    }

    public synchronized boolean isRetryFutile() {
        return this.retryFutile;
    }

    public synchronized void setRetryFutile() {
        this.retryFutile = true;
    }

    public void addInsertListener(InsertListener il) {
        this.listeners.add(il);
    }

    public void removeInsertListener(InsertListener il) {
        this.listeners.remove(il);
    }

    public void fireInsertEvent(InsertEvent evt) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((InsertListener)it.next()).insertProgressed(evt);
        }
    }

    public void fireRestart() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((InsertListener)it.next()).restart();
        }
    }

    public void fireDone() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((InsertListener)it.next()).done();
        }
    }

    public void fireSetStatus(String s) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((InsertListener)it.next()).setStatus(s);
        }
    }

    public void fireIAmHere(Stoppable st) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((InsertListener)it.next()).iamhere(st);
        }
    }

    public synchronized void addlog(String s) {
        this.fireInsertEvent(new InfoInsertEvent(s));
    }

    public synchronized void addlog(int prefix, int retry, int actionIndex, String desc) {
        this.fireInsertEvent(new StructuredJobInsertEvent(prefix, retry, ACTIONS[actionIndex], desc));
    }

    public static String num(int number) {
        return Settings.twoDigits(number);
    }

    public synchronized void notAllUnreachable() {
        this.allUnreachable = 0;
    }

    public synchronized boolean allUnreachable() {
        ++this.allUnreachable;
        return this.allUnreachable > 10;
    }

    public synchronized boolean isAllUnreachable() {
        return this.allUnreachable > 10;
    }

    public synchronized void newChanceForUnreachable() {
        if (this.allUnreachable > 10) {
            this.allUnreachable = 7;
        }
    }

    public synchronized boolean loadProgress(File progressFile, boolean clearProgress) {
        this.progressFile = progressFile;
        if (clearProgress) {
            this.addlog("*** Clearing progress file...");
            this.saveProgress();
        } else {
            try {
                this.addlog("*** Looking for progress file...");
                FileInputStream in = new FileInputStream(progressFile);
                this.progress.load(in);
                ((InputStream)in).close();
                this.addlog("*** Loaded progress file.");
            }
            catch (FileNotFoundException e) {
                this.addlog("*** No progress file found.");
            }
            catch (IOException e) {
                e.printStackTrace();
                e.printStackTrace(FIWSystem.log());
                this.addlog("[Error] while loading progress file");
                return false;
            }
        }
        return true;
    }

    public synchronized void dataInserted(String progressName, String key) {
        this.progress.setProperty(progressName, key);
        this.progress.setProperty("Time." + progressName, "" + System.currentTimeMillis());
        this.saveProgress();
    }

    public synchronized void dataNotInserted(String progressName) {
        this.progress.remove(progressName);
        this.saveProgress();
    }

    private synchronized void saveProgress() {
        if (this.progressFile != null && !FileUtil.saveProperties(this.progress, this.progressFile, "Progress file")) {
            this.addlog("[Warning] Could not save progress file.");
        }
    }

    public String alreadyDone(String progressName) {
        String res = null;
        if (!this.CHECKPROGRESS || (res = this.progress.getProperty(progressName)) != null) {
            // empty if block
        }
        return res;
    }

    public FCPConnection getFCPConnection() {
        return this.fcpConn;
    }
}

