/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.FileUtil;
import fiw.core.I18n;
import fiw.core.insert.InsertContext;
import fiw.core.insert.InsertController;
import fiw.core.insert.KeyFallback;
import fiw.core.jobs.DummyJob;
import fiw.core.jobs.FileInsertJob;
import fiw.core.jobs.InsertJob;
import fiw.core.jobs.Job;
import fiw.core.jobs.MetadataInsertJob;
import java.io.File;
import java.util.ArrayList;

public class FileInsertController
extends InsertController {
    String key;
    String ctype;
    String mdata;
    File f;
    boolean advance;
    Thread myThread;
    private static KeyFallback advanceFallback = new KeyFallback(){

        public String nextKey(String key) {
            if (key == null || key.equals("CHK@")) {
                return null;
            }
            int p = key.lastIndexOf("-");
            if (p == -1) {
                return null;
            }
            try {
                int after = Integer.parseInt(key.substring(p + 1));
                return key.substring(0, p + 1) + (after + 1);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };

    public FileInsertController(InsertContext ic, String key, boolean adv, String ctype, File f) {
        super(ic);
        this.key = key;
        this.ctype = ctype;
        this.f = f;
        this.advance = adv;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public FileInsertController(InsertContext ic, String key, boolean adv, String metadata) {
        super(ic);
        this.key = key;
        this.mdata = metadata;
        this.f = null;
        this.advance = adv;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public boolean insert() {
        Job[] jobs;
        if (this.f == null) {
            this.ic.addlog("======== Inserting metadata (FIW 0.08) =========\nHTL: " + this.ic.htl + "\n" + "Key: " + FileInsertController.mungeSSK(this.key) + "\n" + "Start of insert: " + FileUtil.dateString2() + "\n" + "FCP host/port: " + this.fc.getHost() + ":" + this.fc.getPort() + "\n" + (this.advance ? "[AutoAdvance]\n" : "") + "==============================================*=\n\n");
        } else {
            this.ic.addlog("========== Inserting file (FIW 0.08) ===========\nFilename: " + this.f.getName() + "\n" + "Content-Type: " + this.ctype + "\n" + "HTL: " + this.ic.htl + "\n" + "Key: " + FileInsertController.mungeSSK(this.key) + "\n" + "Start of insert: " + FileUtil.dateString2() + "\n" + "FCP host/port: " + this.fc.getHost() + ":" + this.fc.getPort() + "\n" + (this.advance ? "[AutoAdvance]\n" : "") + "==============================================*=\n\n");
        }
        ArrayList<Job> verifyList = new ArrayList<Job>();
        int resJob = -1;
        if (this.ic.shouldStop()) {
            jobs = new Job[]{};
        } else if (this.f != null && (this.f.length() < (long)this.ic.MAXNIMSIZE || this.key.equals("CHK@")) && !this.key.equals("none")) {
            jobs = new Job[]{new FileInsertJob(this.f, "metadata+data", this.ctype, "", true, this.key, "Version\nRevision=1\nEndPart\nDocument\nInfo.Format=" + this.ctype + "\nEnd\n", this.ic, new Job[0])};
            if (this.advance) {
                ((InsertJob)jobs[0]).setFallback(advanceFallback);
            }
            verifyList.add(jobs[0]);
            resJob = 0;
        } else if (this.f != null && !this.key.equals("none")) {
            jobs = new Job[3];
            jobs[0] = new FileInsertJob(this.f, "file", this.ctype, "", true, false, this.ic, new Job[0]);
            ((InsertJob)jobs[0]).setCalcOnly();
            jobs[1] = new MetadataInsertJob(this.key, null, "metadata", this.ic, new Job[]{jobs[0]});
            jobs[2] = new FileInsertJob(this.f, "file", this.ctype, "", true, false, this.ic, new Job[0]);
            if (this.advance) {
                ((InsertJob)jobs[1]).setFallback(advanceFallback);
            }
            verifyList.add(jobs[1]);
            verifyList.add(jobs[2]);
            resJob = 1;
        } else if (this.f != null && this.key.equals("none")) {
            jobs = new Job[]{new FileInsertJob(this.f, "file", this.ctype, "", true, false, this.ic, new Job[0])};
            verifyList.add(jobs[0]);
            resJob = 0;
        } else {
            jobs = new Job[]{new MetadataInsertJob(this.key, this.mdata, "metadata", this.ic, new Job[0])};
            resJob = 0;
            if (this.advance) {
                ((InsertJob)jobs[0]).setFallback(advanceFallback);
            }
            verifyList.add(jobs[0]);
        }
        if (this.ic.doVerify(true)) {
            int jc = jobs.length;
            int jc2 = verifyList.size();
            Job[] newjobs = new Job[jc + jc2 + 1];
            System.arraycopy(jobs, 0, newjobs, 0, jc);
            newjobs[jc] = new DummyJob("=============================\nFetching inserted data again:", this.ic, jobs);
            for (int i = 0; i < jc2; ++i) {
                newjobs[jc + i + 1] = ((InsertJob)verifyList.get(i)).buildChecker(true, null, newjobs[jc]);
            }
            jobs = newjobs;
        }
        boolean fail = false;
        if (!this.ic.shouldStop()) {
            boolean bl = fail = !this.runJobList(jobs);
        }
        if (this.ic.shouldStop()) {
            this.ic.addlog("\n+++ Aborted +++");
        } else {
            if (fail) {
                this.ic.addlog("Fatal error. Quitting.");
                this.ic.fireSetStatus(I18n.get("Error"));
                this.ic.addlog("\n+++ FAILED +++");
                return false;
            }
            this.ic.addlog("\n+++ FINISHED +++\n");
            if (resJob != -1) {
                this.ic.addlog("Your URI: " + ((InsertJob)jobs[resJob]).getResultKey());
            }
        }
        return true;
    }

    public static String mungeSSK(String key) {
        int endPos;
        if (key.startsWith("SSK@") && (endPos = key.indexOf("/")) > 12) {
            key = key.substring(0, 8) + "[--cut--]" + key.substring(endPos - 4);
        }
        return key;
    }
}

