/*
 * Decompiled with CFR 0.152.
 */
package fiw.core.insert;

import fiw.core.insert.FreenetContainer;

public class FileClass {
    private int matchtype;
    private int priority;
    private FreenetContainer container;
    private String match;
    public static final int EXACT_MATCH = 0;
    public static final int END_MATCH = 1;
    public static final int REGEX_MATCH = 2;

    public FileClass(int matchtype, String match, int priority, FreenetContainer container) {
        this.matchtype = matchtype;
        this.match = match;
        this.priority = priority;
        this.container = container;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isContainer() {
        return this.container != null;
    }

    public FreenetContainer getContainer() {
        return this.container;
    }

    public boolean matchesFile(String filename) {
        switch (this.matchtype) {
            case 0: {
                return filename.equals(this.match);
            }
            case 1: {
                return filename.endsWith(this.match);
            }
            case 2: {
                return filename.matches(this.match);
            }
        }
        throw new UnsupportedOperationException("Unknown match type");
    }
}

