/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.MyLogger;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ToFileLogger
implements MyLogger {
    private PrintWriter logfile;
    private String loggerState = null;

    public ToFileLogger(String xtrasuffix) {
        try {
            String filename = "report-" + this.noPunctuation(xtrasuffix) + FileUtil.dateString() + ".log";
            this.logfile = new PrintWriter((Writer)new FileWriter(filename), true);
            this.loggerState = "Report is saved as \"" + filename + "\".\n";
        }
        catch (IOException e) {
            this.logfile = null;
            this.loggerState = "No report is saved - IO error.\n";
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
        }
    }

    private String noPunctuation(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '-' && !Character.isLetterOrDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public String getLoggerState() {
        return this.loggerState;
    }

    public synchronized void addlog(String s) {
        if (this.logfile != null) {
            int pos;
            while ((pos = s.indexOf("\n")) != -1) {
                this.logfile.println(s.substring(0, pos));
                s = s.substring(pos + 1);
            }
            this.logfile.println(s);
        }
    }

    public synchronized void addlogNoNewline(String s) {
        if (this.logfile != null) {
            this.logfile.print(s);
        }
    }

    public synchronized void done() {
        if (this.logfile != null) {
            this.logfile.close();
        }
    }
}

