/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.MyLogger;

public class ThreadCounter {
    private int maxThreads;
    private int freeThreads;
    private MyLogger logger;

    public ThreadCounter(int max, MyLogger logger) {
        this.maxThreads = max;
        this.freeThreads = max;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread() {
        try {
            ThreadCounter threadCounter = this;
            synchronized (threadCounter) {
                while (this.freeThreads <= 0) {
                    this.wait();
                }
                --this.freeThreads;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logger.addlog("FATAL!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllThreads() {
        ThreadCounter threadCounter = this;
        synchronized (threadCounter) {
            try {
                while (this.freeThreads < this.maxThreads) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.logger.addlog("FATAL!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseThread() {
        ThreadCounter threadCounter = this;
        synchronized (threadCounter) {
            ++this.freeThreads;
            this.notifyAll();
        }
    }

    public synchronized boolean isRunning() {
        return this.freeThreads < this.maxThreads;
    }
}

