/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SubFile
extends File {
    private String subName;

    public SubFile(File parent, String name, String prefix) {
        super(parent, name);
        this.subName = prefix + name;
    }

    public void setSubName(String sn) {
        this.subName = sn;
    }

    public String getSubName() {
        return this.subName;
    }

    public static SubFile[] listSubFiles(File root, List ignoreFiles) {
        ArrayList cache = new ArrayList();
        SubFile.listSubFiles("", root, SubFile.getParsedDir(root), cache, ignoreFiles);
        return cache.toArray(new SubFile[0]);
    }

    private static File getParsedDir(File r) {
        File f = FileUtil.fiwDir(r);
        if (!(f = new File(f, "parsed")).exists()) {
            f.mkdir();
        }
        return f;
    }

    private static void listSubFiles(String prefix, File root, File rootParsed, ArrayList cache, List ignoreFiles) {
        File[] sons = root.listFiles();
        for (int i = 0; i < sons.length; ++i) {
            File parsedFile = new File(rootParsed, sons[i].getName());
            if (sons[i].getName().startsWith(".") || ignoreFiles != null && ignoreFiles.contains(sons[i].getName())) continue;
            if (sons[i].isDirectory() && !sons[i].getName().startsWith("__")) {
                SubFile.listSubFiles(prefix + sons[i].getName() + "/", sons[i], parsedFile, cache, ignoreFiles);
                continue;
            }
            if (sons[i].isDirectory()) continue;
            if (parsedFile.exists()) {
                cache.add(new SubFile(rootParsed, sons[i].getName(), prefix));
                continue;
            }
            cache.add(new SubFile(root, sons[i].getName(), prefix));
        }
    }
}

