/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.EnumerationIterator;
import fiw.core.FileUtil;
import fiw.core.MyLogger;
import fiw.core.option.GlobalOptions;
import fiw.core.option.Option;
import fiw.core.option.Options;
import fiw.fcp.FCPConnection;
import fiw.fcp.FCPInsertResult;
import fiw.fcp.InsertSuccessResult;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;

public class Settings {
    private static Settings inst;
    private Properties prop;

    protected static synchronized Settings getInstance() {
        if (inst == null) {
            inst = new Settings();
            inst.checkSettings();
        }
        return inst;
    }

    private Settings() {
        Properties defprop = new Properties();
        GlobalOptions gos = new GlobalOptions(false, false);
        Option[] sets = gos.getSettings();
        for (int i = 0; i < sets.length; ++i) {
            Option o = sets[i];
            if (o.isSpecial() || o.getProperty() == null) continue;
            defprop.setProperty(o.getProperty(), o.getDefault());
        }
        this.prop = new Properties(defprop);
        try {
            FileInputStream in = new FileInputStream("fiw.conf");
            this.prop.load(in);
            ((InputStream)in).close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            FileOutputStream out = new FileOutputStream("fiw.conf");
            this.prop.store(out, "FIW settings");
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getProjCount() {
        return Integer.parseInt(this.prop.getProperty("proj.count"));
    }

    public void setProjCount(int count) {
        this.prop.setProperty("proj.count", "" + count);
        this.flush();
    }

    public String[] getProjectNames() {
        int cnt = this.getProjCount();
        String[] result = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            result[i] = this.prop.getProperty("proj." + i + ".name");
        }
        return result;
    }

    public static String getEditionString(int number) {
        String ss = "" + number;
        if (number >= 11000 && number < 12000) {
            return ss.substring(ss.length() - 3);
        }
        return ss;
    }

    public String getPrivateURI(int project, boolean testing) {
        return this.getPrivateURI(project, testing, 0);
    }

    public String getPrivateURI(int project, boolean testing, int slot) {
        Settings ss = this;
        int edition = Integer.parseInt(ss.getProjectSetting(project, "editionx"));
        String uri = ss.getProjectSetting(project, "pubkey").equals("KSK") ? "KSK@" + (testing ? "htl0test/" : "") + ss.getProjectSetting(project, "keydir") + (edition == 0 ? "" : "/" + Settings.getEditionString(edition)) : (ss.getProjectSetting(project, "pubkey").equals("CHK") ? "CHK@" : "SSK@" + ss.getProjectSetting(project, "privkey") + ss.getMaybeEntropy(project) + "/" + (slot == 0 ? "" : Integer.toHexString(slot) + "-") + (testing ? "htl0test/" : "") + ss.getProjectSetting(project, "keydir") + (edition == 0 ? "" : "/" + Settings.getEditionString(edition)));
        return uri;
    }

    public String getMaybeEntropy(int project) {
        String entropy = this.getProjectSettingDef(project, "entropy", "");
        return entropy.length() == 0 ? "" : "," + entropy;
    }

    public String getPublicURI(int project, boolean testing, int editioninc) {
        Settings ss = this;
        int edition = 0;
        edition = editioninc == -1 ? 0 : (editioninc != 0 ? Integer.parseInt(ss.getProjectSetting(project, "editionx")) + editioninc : Integer.parseInt(ss.getProjectSetting(project, "editionx")));
        String uri = ss.getProjectSetting(project, "pubkey").equals("KSK") ? "KSK@" + (testing ? "htl0test/" : "") + ss.getProjectSetting(project, "keydir") + (edition == 0 ? "" : "/" + Settings.getEditionString(edition)) : (ss.getProjectSetting(project, "pubkey").equals("CHK") ? "CHK@" : "SSK@" + ss.getProjectSetting(project, "pubkey") + "PAgM" + this.getMaybeEntropy(project) + "/" + (testing ? "htl0test/" : "") + ss.getProjectSetting(project, "keydir") + (edition == 0 ? "" : "/" + Settings.getEditionString(edition)));
        return uri;
    }

    public File getProjectFile(int no) {
        return new File(this.getProjectSetting(no, "path"));
    }

    public void setProperty(String name, String val) {
        this.prop.setProperty(name, val);
        this.flush();
    }

    public String getProperty(String name) {
        return this.prop.getProperty(name);
    }

    public void renameProperties(String from, String to) {
        this.copyProperties(from, to, true);
    }

    public void copyProperties(String from, String to, boolean move) {
        Iterator i = new EnumerationIterator(this.prop.propertyNames());
        ArrayList<String> al = new ArrayList<String>();
        while (i.hasNext()) {
            String el = (String)i.next();
            if (!el.startsWith(from)) continue;
            al.add(el);
        }
        i = al.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String newKey = to + key.substring(from.length());
            String value = this.prop.getProperty(key);
            this.prop.setProperty(newKey, value);
            if (!move) continue;
            this.prop.remove(key);
        }
        this.flush();
    }

    public void deleteProperties(String prefix) {
        Iterator it = new EnumerationIterator(this.prop.propertyNames());
        ArrayList<String> al = new ArrayList<String>();
        while (it.hasNext()) {
            String el = (String)it.next();
            if (!el.startsWith(prefix)) continue;
            al.add(el);
        }
        it = al.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.prop.remove(key);
        }
        this.flush();
    }

    public void saveProject(int num, String property, String value) {
        if (num >= this.getProjCount()) {
            this.prop.setProperty("proj.count", "" + (num + 1));
        }
        this.prop.setProperty("proj." + num + "." + property, value);
        this.flush();
    }

    public String getProjectSetting(int pro, String name) {
        return this.prop.getProperty("proj." + pro + "." + name);
    }

    public String getProjectSettingDef(int pro, String name, String defaul) {
        String res = this.prop.getProperty("proj." + pro + "." + name);
        return res == null ? defaul : res;
    }

    public boolean doTest(FCPConnection fcpConn, int project, MyLogger logger) {
        logger.addlogNoNewline("Checking if path exists...");
        File path = this.getProjectFile(project);
        if (!path.exists()) {
            logger.addlog("FAILED!");
            return false;
        }
        logger.addlog("OK");
        logger.addlogNoNewline("Checking if URI is valid...");
        boolean b = this.checkURI(fcpConn, project);
        if (!b) {
            logger.addlog("FAILED!");
            if (this.getProjectSetting(project, "pubkey").endsWith("PAgM")) {
                logger.addlog("Perhaps you should remove the PAgM from the end of your public key?");
            }
            return false;
        }
        logger.addlog("OK");
        logger.addlogNoNewline("Checking for index.html...");
        if (!new File(path, "__index.html").exists() && !new File(path, "index.html").exists()) {
            logger.addlog("FAILED!");
            return false;
        }
        logger.addlog("OK");
        String cset = this.getProjectSettingDef(project, "charset", "");
        if (cset.length() != 0) {
            logger.addlogNoNewline("Checking charset...");
            try {
                "".getBytes(cset);
            }
            catch (UnsupportedEncodingException e) {
                logger.addlog("FAILED!");
                return false;
            }
            logger.addlog("OK");
        }
        return true;
    }

    private boolean checkURI(FCPConnection fcpConn, int project) {
        String priv = this.getPrivateURI(project, true);
        for (int i = 0; i < priv.length(); ++i) {
            if (priv.charAt(i) <= '~' && priv.charAt(i) >= '+') continue;
            return false;
        }
        String pub = this.getPublicURI(project, true, 0);
        String rand = "" + new Random().nextInt(100000000);
        if (pub.equals("CHK@")) {
            return true;
        }
        FCPInsertResult ins = fcpConn.insertStream(priv + "--testing" + rand, "Version\nRevision=1\nComment=SyntaxCheck\nEnd\n", new ByteArrayInputStream(new byte[0]), 0, 0L, "CHECKINSERT");
        if (ins == null || !(ins instanceof InsertSuccessResult)) {
            return false;
        }
        return ins.getKey().equals(pub + "--testing" + rand);
    }

    public static String makeTime(int seconds) {
        return Settings.twoDigits(seconds / 3600) + ":" + Settings.twoDigits(seconds / 60 % 60) + ":" + Settings.twoDigits(seconds % 60);
    }

    public static String twoDigits(int i) {
        return (i < 10 ? "0" : "") + i;
    }

    public static int parseTime(String timeValue) {
        try {
            StringTokenizer time = new StringTokenizer(timeValue, ":");
            int value = 3600;
            int result = 0;
            while (time.hasMoreTokens()) {
                result += Integer.parseInt(time.nextToken()) * value;
                value /= 60;
            }
            return result;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String loadFileRaw(File f) {
        try {
            DataInputStream fis = new DataInputStream(new FileInputStream(f));
            byte[] b = new byte[(int)f.length()];
            fis.readFully(b);
            return new String(b, "ISO-8859-1");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int updateNimNumber(int project) {
        int nimnum = Integer.parseInt(this.getProjectSettingDef(project, "nextnim", "1"));
        String fetchednims = this.getProjectSettingDef(project, "checkednims", "");
        while (fetchednims.indexOf("(" + nimnum + ")") != -1) {
            ++nimnum;
        }
        return nimnum;
    }

    private void checkSettings() {
        HashSet<String> done = new HashSet<String>();
        int cnt = this.getProjCount();
        for (int i = 0; i < cnt; ++i) {
            Options opts = new Options(i);
            Option[] sets = opts.getSettings();
            for (int j = 0; j < sets.length; ++j) {
                Option o = sets[j];
                if (o.isSpecial()) continue;
                done.add("proj." + i + "." + o.getProperty());
            }
        }
        Option[] gopts = new GlobalOptions(true).getSettings();
        for (int i = 0; i < gopts.length; ++i) {
            Option o = gopts[i];
            if (o.isSpecial()) continue;
            done.add(o.getProperty());
        }
        EnumerationIterator it = new EnumerationIterator(this.prop.propertyNames());
        while (it.hasNext()) {
            String next = (String)it.next();
            if (done.contains(next)) continue;
            System.out.println("*** obsolete/unknown setting: " + next + "=" + this.prop.getProperty(next));
        }
    }

    public void makeReport() {
        HashSet<String> done = new HashSet<String>();
        StringBuffer report = new StringBuffer("Report about FIW.conf dated " + FileUtil.dateString2() + "\n");
        report.append("FCP address: " + this.prop.getProperty("fcp.host") + ":" + this.prop.getProperty("fcp.port") + "\n");
        done.add("fcp.host");
        done.add("fcp.port");
        report.append("\nProject listing:\n===============\n");
        done.add("proj.count");
        int cnt = this.getProjCount();
        for (int i = 0; i < cnt; ++i) {
            report.append("\nProject ").append(i).append(": ").append(this.getProjectSetting(i, "name")).append("\n\n");
            Option[] opts = new Options(i).getSettings();
            for (int j = 0; j < opts.length; ++j) {
                Option o = opts[j];
                if (o.isSpecial()) continue;
                report.append(o.getName()).append("=").append(o.getValue()).append("\n");
                done.add("proj." + i + "." + o.getProperty());
            }
        }
        report.append("\nTuning options:\n==============\n\n");
        Option[] gopts = new GlobalOptions(true).getSettings();
        for (int i = 0; i < gopts.length; ++i) {
            Option o = gopts[i];
            if (o.isSpecial()) continue;
            report.append(o.getName()).append("=").append(o.getValue()).append("\n");
            done.add(o.getProperty());
        }
        report.append("\nStrange settings:\n=================\n\n");
        EnumerationIterator it = new EnumerationIterator(this.prop.propertyNames());
        while (it.hasNext()) {
            String next = (String)it.next();
            if (done.contains(next)) continue;
            report.append(next).append("=").append(this.prop.getProperty(next)).append("\n");
        }
        report.append("+++ finished +++");
        FileUtil.saveFile(new File("fiw-conf-report.log"), report.toString());
    }
}

