/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class PaddingInputStream
extends InputStream {
    private long remaining;
    private InputStream in;

    public PaddingInputStream(InputStream in, long skip, long length) throws IOException {
        this.in = in;
        long skipped = -1L;
        for (long toskip = skip; toskip > 0L; toskip -= skipped) {
            long lastskipped = skipped;
            skipped = in.skip(toskip);
            if (skipped == 0L && lastskipped == 0L) break;
        }
        this.remaining = length;
    }

    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int b = this.in.read();
        if (b == -1) {
            b = 0;
        }
        --this.remaining;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.remaining < 0L) {
            throw new RuntimeException("Remaining = " + this.remaining);
        }
        if (this.remaining == 0L) {
            return -1;
        }
        int length = len;
        if ((long)length > this.remaining) {
            length = (int)this.remaining;
        }
        if ((result = this.in.read(b, off, length)) == -1) {
            result = length;
            Arrays.fill(b, off, length, (byte)0);
        }
        this.remaining -= (long)result;
        return result;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

