/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.I18n;
import fiw.core.Settings;
import fiw.core.insert.InsertContext;
import fiw.core.insert.InsertController;
import fiw.core.jobs.Job;
import fiw.core.jobs.RetrieveCheckJob;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class NimCheckerController
extends InsertController {
    private InsertContext ic;
    private int advance;

    public NimCheckerController(InsertContext ic, int advance) {
        super(ic);
        this.ic = ic;
        this.advance = advance;
        ic.fireSetStatus(I18n.get("NIMProgress"));
        new Thread(this).start();
    }

    public void run() {
        this.ic.fireIAmHere(this);
        this.insert();
        this.ic.fireDone();
    }

    public boolean insert() {
        this.ic.addlog("======== Checking your NIMs (FIW 0.08) =========\nAdvance: " + this.advance + "\n" + "HTL: " + this.ic.fetchHTL + "\n" + "Start of check: " + FileUtil.dateString2() + "\n" + "FCP host/port: " + this.fc.getHost() + ":" + this.fc.getPort() + "\n" + "================================================\n\n");
        Settings ss = FIWSystem.getInstance().getSettings();
        int count = ss.getProjCount();
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<int[]> numbers = new ArrayList<int[]>();
        this.ic.addlog("*** Checking projects...");
        int total = 0;
        for (int i = 0; i < count; ++i) {
            int num;
            String prefix = ss.getProjectSetting(i, "nimprefix");
            if (prefix == null || "".equals(prefix)) continue;
            String checkednims = ss.getProjectSettingDef(i, "checkednims", "");
            try {
                num = Integer.parseInt(ss.getProjectSetting(i, "nextnim"));
            }
            catch (NumberFormatException e) {
                num = 1;
            }
            int found = 0;
            int[] nimlist = new int[this.advance];
            while (found < this.advance) {
                if (checkednims.indexOf("(" + num + ")") == -1) {
                    nimlist[found] = num;
                    ++found;
                }
                ++num;
            }
            this.ic.addlog("KSK@" + prefix + "-:" + this.printList(nimlist));
            prefixes.add(prefix);
            numbers.add(nimlist);
            ++total;
        }
        Job[] NO_DEPS = new Job[]{};
        Job[] jobs = new Job[total * this.advance];
        for (int i = 0; i < this.advance; ++i) {
            for (int j = 0; j < total; ++j) {
                String key = "KSK@" + (String)prefixes.get(j) + "-" + ((int[])numbers.get(j))[i];
                jobs[i * total + j] = new RetrieveCheckJob(key, "-", key, "", this.ic, NO_DEPS);
            }
        }
        this.ic.addlog("*** Finished checking projects");
        this.ic.addlog("*** Trying to fetch NIMs...");
        if (!this.ic.shouldStop()) {
            this.runJobList(jobs);
        }
        if (this.ic.shouldStop()) {
            this.ic.addlog("+++ Aborted +++");
            this.ic.fireSetStatus(I18n.get("StatusAborted"));
            this.ic.fireDone();
            return false;
        }
        Vector<String> successes = new Vector<String>();
        for (int i = 0; i < this.advance * total; ++i) {
            if (!jobs[i].hasFinished() || !jobs[i].wasSuccessful()) continue;
            successes.add(((RetrieveCheckJob)jobs[i]).getKey());
        }
        this.ic.addlog("*** " + successes.size() + " NIMs found:");
        Iterator it = successes.iterator();
        String FPROXY_URL = FIWSystem.setts().getProperty("fproxy.url");
        try {
            BufferedWriter htmlw = new BufferedWriter(new FileWriter("foundnims.html"));
            BufferedWriter fw = new BufferedWriter(new FileWriter("foundnims.log", true));
            htmlw.write("<html><head><title>FIW 0.08 - found NIMs</title></head><body bgcolor=\"#BBBBBB\"><h1>Found NIMs</h1>");
            htmlw.newLine();
            while (it.hasNext()) {
                String next = (String)it.next();
                this.ic.addlog(next);
                fw.write(next);
                fw.newLine();
                htmlw.write("<h2>" + next + "</h2><iframe width=\"100%\" height" + "=200 src=\"" + FPROXY_URL + next + "\"></iframe>");
                htmlw.newLine();
                int pos = next.indexOf("-");
                String prefix = next.substring(4, pos);
                String tail = next.substring(pos + 1);
                for (int i = 0; i < count; ++i) {
                    if (!prefix.equals(ss.getProjectSetting(i, "nimprefix"))) continue;
                    String old = ss.getProjectSettingDef(i, "checkednims", "");
                    ss.saveProject(i, "checkednims", old + "(" + tail + ")");
                }
            }
            fw.flush();
            fw.close();
            htmlw.write("</body></html>");
            htmlw.newLine();
            htmlw.flush();
            htmlw.close();
            this.ic.addlog("+++ FINISHED +++");
            this.ic.addlog("\nfoundnims.log contains all NIMs ever found (until you delete them).");
            this.ic.addlog("foundnims.html contains iframes for all NIMs found in this run.");
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            this.ic.addlog("[Error] unexpected error - check logfile");
        }
        this.ic.fireSetStatus(I18n.format("NIMsFound", new Integer(successes.size())));
        return true;
    }

    private String printList(int[] list) {
        String result = " ";
        for (int i = 0; i < list.length; ++i) {
            result = result + list[i] + " ";
        }
        return result;
    }
}

