/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18n {
    private Locale locale = null;
    private ResourceBundle rb = null;

    public I18n() {
        this(Locale.getDefault());
    }

    public I18n(String locale) {
        this(I18n.getLocaleFromString(locale));
    }

    public I18n(Locale l) {
        this.locale = l;
        this.rb = ResourceBundle.getBundle("res/language", this.locale);
    }

    private static Locale getLocaleFromString(String locale) {
        Locale l;
        int pos = locale.indexOf("_");
        if (pos == -1) {
            l = new Locale(locale);
        } else {
            String lang = locale.substring(0, pos);
            String rest = locale.substring(pos + 1);
            pos = locale.indexOf("_");
            if (pos == 0) {
                l = new Locale(lang, rest);
            } else {
                String country = locale.substring(0, pos);
                rest = locale.substring(pos + 1);
                l = new Locale(lang, country, rest);
            }
        }
        return l;
    }

    public static String get(String name) {
        return FIWSystem.getInstance().getI18n().getString(name);
    }

    public static String format(String format, Object param) {
        return I18n.format(format, new Object[]{param});
    }

    public static String format(String format, Object[] params) {
        I18n i = FIWSystem.getInstance().getI18n();
        String form = i.getString(format);
        return new MessageFormat(form, i.getLocale()).format(params);
    }

    public String getString(String name) {
        return this.rb.getString(name);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

