/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import fiw.core.InputStreamBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static String hashCipher() {
        if ("true".equals(FIWSystem.setts().getProperty("tuning.newhash"))) {
            return "SHA1";
        }
        return "MD5";
    }

    public static String calcMD5(String data) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(HashUtil.hashCipher());
            md5.reset();
            md5.update(data.getBytes("ISO-8859-1"));
            return HashUtil.bytesToHex(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(FIWSystem.log());
            e.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    public static String calcMD5(File file) {
        try {
            int len;
            FileInputStream fin = new FileInputStream(file);
            MessageDigest md5 = MessageDigest.getInstance(HashUtil.hashCipher());
            md5.reset();
            byte[] b = new byte[65536];
            while ((len = fin.read(b)) != -1) {
                md5.update(b, 0, len);
            }
            return HashUtil.bytesToHex(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return null;
        }
    }

    public static String[] calcMD5andSHA1(File file) {
        try {
            int len;
            String hashCipher = HashUtil.hashCipher();
            FileInputStream fin = new FileInputStream(file);
            MessageDigest md5 = null;
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            if (!hashCipher.equals("SHA1")) {
                md5 = MessageDigest.getInstance("MD5");
            }
            if (md5 != null) {
                md5.reset();
            }
            sha1.reset();
            byte[] b = new byte[65536];
            while ((len = fin.read(b)) != -1) {
                if (md5 != null) {
                    md5.update(b, 0, len);
                }
                sha1.update(b, 0, len);
            }
            byte[] sha1digest = sha1.digest();
            byte[] md5digest = md5 == null ? sha1digest : md5.digest();
            return new String[]{HashUtil.bytesToHex(md5digest), HashUtil.bytesToHex(sha1digest)};
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return new String[]{null, null};
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return new String[]{null, null};
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            sb.append(c < 16 ? "0" : "").append(Integer.toHexString(c));
        }
        return sb.toString();
    }

    public static String makeFingerprint(String metadata, InputStreamBuilder data, long dataLength) {
        try {
            int len;
            InputStream in = data.buildStream();
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.reset();
            sha1.update(metadata.getBytes("ISO-8859-1"));
            byte[] b = new byte[65536];
            while ((len = in.read(b)) != -1) {
                sha1.update(b, 0, len);
            }
            return metadata.length() + "/" + dataLength + "/" + HashUtil.bytesToHex(sha1.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return "";
        }
    }
}

