/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.MyLogger;
import fiw.core.Settings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class HTMLParser {
    private Properties vars;
    private Properties defVars;
    private Properties templates = new Properties();
    private File srcDir;
    private File dstDir;
    private File incDir;
    private String charset;
    private MyLogger ml;
    private boolean hasErrors = false;
    private Date baseDate;
    public static final String NEWLINE = System.getProperty("line.separator");

    public boolean getErrors() {
        return this.hasErrors;
    }

    public HTMLParser(int projectnum, boolean test, MyLogger ml) {
        String lockedTime;
        this.ml = ml;
        Settings ss = FIWSystem.getInstance().getSettings();
        this.defVars = new Properties();
        this.defVars.setProperty("ps.ednum", ss.getProjectSetting(projectnum, "editionx"));
        this.defVars.setProperty("ps.projname", ss.getProjectSetting(projectnum, "name"));
        this.defVars.setProperty("ps.nimpref", ss.getProjectSettingDef(projectnum, "nimprefix", ""));
        this.defVars.setProperty("ps.nextnim", ss.getProjectSettingDef(projectnum, "nextnim", ""));
        this.defVars.setProperty("ps.actlink", ss.getProjectSetting(projectnum, "activelink"));
        this.defVars.setProperty("ps.keyonly", "/SSK@" + ss.getProjectSetting(projectnum, "pubkey") + "PAgM" + ss.getMaybeEntropy(projectnum));
        this.defVars.setProperty("ps.pubkey", ss.getProjectSetting(projectnum, "pubkey"));
        this.defVars.setProperty("ps.keydir", (test ? "htl0test/" : "") + ss.getProjectSetting(projectnum, "keydir"));
        this.defVars.setProperty("ps.key", "/" + ss.getPublicURI(projectnum, test, -1));
        this.defVars.setProperty("ps.keynoslash", ss.getPublicURI(projectnum, test, -1));
        this.defVars.setProperty("tags.title", this.htmlescape(ss.getProjectSetting(projectnum, "title")));
        this.defVars.setProperty("tags.category", this.htmlescape(ss.getProjectSetting(projectnum, "category")));
        this.defVars.setProperty("tags.author", this.htmlescape(ss.getProjectSetting(projectnum, "author")));
        this.defVars.setProperty("tags.description", this.htmlescape(FileUtil.loadFile(new File(ss.getProjectFile(projectnum), "description.txt"))));
        this.srcDir = ss.getProjectFile(projectnum);
        this.dstDir = new File(FileUtil.fiwDir(this.srcDir), "parsed");
        if (!this.dstDir.exists()) {
            this.dstDir.mkdirs();
        }
        this.incDir = new File(FileUtil.fiwDir(this.srcDir), "include");
        if (!this.incDir.exists()) {
            this.incDir.mkdir();
        }
        this.vars = new Properties(this.defVars);
        this.charset = ss.getProjectSettingDef(projectnum, "charset", "");
        if (this.charset.length() == 0) {
            this.charset = "ISO-8859-1";
        }
        this.baseDate = (lockedTime = ss.getProjectSettingDef(projectnum, "lockedtime", "")).length() == 0 ? new Date() : new Date(Long.parseLong(lockedTime));
    }

    public void parseAll() {
        try {
            String line;
            File f = new File(FileUtil.fiwDir(this.srcDir), "parse.ini");
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.startsWith(":") || line.length() == 0 || !new File(this.srcDir, line).exists()) continue;
                this.parse(line);
            }
            br.close();
        }
        catch (IOException e) {
            this.ml.addlog("[Error] internal error, consult logfile");
            this.hasErrors = true;
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
        }
    }

    public synchronized void parse(String filename) {
        this.ml.addlog("     parsing " + filename);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.srcDir, filename)), this.charset));
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.dstDir, filename)), this.charset));
            StringBuffer all = new StringBuffer();
            while ((line = br.readLine()) != null) {
                all.append(line).append(NEWLINE);
            }
            bw.write(this.parseString(all.toString()));
            bw.flush();
            bw.close();
            br.close();
        }
        catch (IOException e) {
            this.ml.addlog("[Error] internal error, consult logfile");
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            this.hasErrors = true;
        }
    }

    private String parseString(String data) throws IOException {
        int p;
        StringBuffer done;
        StringBuffer to = done = new StringBuffer();
        int index = 0;
        String todef = null;
        if (data == null) {
            return null;
        }
        while (index < data.length() && (p = data.indexOf("#$#", index)) != -1) {
            if (data.charAt(p + 3) == '#') {
                to.append(data.substring(index, p + 2));
                index = p + 3;
                continue;
            }
            int p2 = data.indexOf(";", p);
            if (p2 == -1) break;
            to.append(data.substring(index, p));
            String between = data.substring(p + 3, p2);
            if (between.startsWith("def:")) {
                if (todef != null) {
                    this.vars.setProperty(todef, to.toString());
                    if (todef.startsWith("add:") && this.vars.getProperty(todef.substring(4)) == null) {
                        this.vars.setProperty(todef.substring(4), to.toString());
                    }
                    todef = null;
                }
                if (between.equals("def:end")) {
                    to = done;
                } else {
                    to = new StringBuffer();
                    todef = between.substring(4);
                }
            } else {
                to.append(this.parseTag(between));
            }
            index = p2 + 1;
        }
        to.append(data.substring(index));
        if (todef != null) {
            this.ml.addlog("[Parse Error] Definition of #$#" + todef + "; not ended.");
            todef = null;
            this.hasErrors = true;
        }
        return done.toString();
    }

    private String parseTag(String tag) throws IOException {
        if (tag.equals("/")) {
            return "/";
        }
        if (tag.startsWith("e:")) {
            try {
                int num = Integer.parseInt(this.parseTag(tag.substring(2)));
                if (num < 1) {
                    num = 1;
                }
                return Settings.getEditionString(num);
            }
            catch (NumberFormatException e) {
                return Settings.getEditionString(1);
            }
        }
        if (tag.startsWith("url:")) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new URL(tag.substring(4)).openStream(), "ISO-8859-1"));
                StringBuffer inc = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    inc.append(line).append(NEWLINE);
                }
                return inc.toString();
            }
            catch (IOException e) {
                e.printStackTrace(FIWSystem.log());
                this.ml.addlog("[Parse Error] Problems with " + tag + ", consult logfile.");
                this.hasErrors = true;
                return "";
            }
        }
        if (tag.startsWith("file:")) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.incDir, tag.substring(5))), this.charset));
                StringBuffer inc = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    inc.append(line).append(NEWLINE);
                }
                return inc.toString();
            }
            catch (FileNotFoundException e) {
                this.ml.addlog("[Parse Error] " + tag + " not found");
                this.hasErrors = true;
                return "";
            }
        }
        if (tag.startsWith("date:")) {
            String formatString = tag.substring(5);
            if (formatString.length() == 0) {
                formatString = "EEEE, yyyy-MM-dd HH:mm:ss";
            }
            SimpleDateFormat sdf = new SimpleDateFormat(formatString, Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            return sdf.format(this.baseDate);
        }
        int p = tag.indexOf("+");
        if (p != -1) {
            try {
                return "" + (Integer.parseInt(this.parseTag(tag.substring(0, p))) + Integer.parseInt(this.parseTag(tag.substring(p + 1))));
            }
            catch (NumberFormatException e) {
                this.ml.addlog("[Parse error] not a number: \"" + tag + "\"");
                this.hasErrors = true;
                return "#NaN#";
            }
        }
        if (this.isInteger(tag)) {
            return tag;
        }
        String value = this.vars.getProperty(tag.toLowerCase());
        if (value != null) {
            return value;
        }
        value = this.parseString(this.getTemplate(tag.toLowerCase()));
        if (value != null) {
            return value;
        }
        this.ml.addlog("[Parse error] undefined tag \"" + tag + "\"");
        this.hasErrors = true;
        return "#undefined#";
    }

    private boolean isInteger(String text) {
        boolean ret = true;
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            ret = false;
        }
        return ret;
    }

    private String getTemplate(String name) throws IOException {
        String value = this.templates.getProperty(name);
        if (value != null) {
            return value;
        }
        try {
            String line;
            FileInputStream fis;
            try {
                fis = new FileInputStream("templates.html");
            }
            catch (FileNotFoundException e) {
                fis = new FileInputStream("../templates.html");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "ISO-8859-1"));
            boolean add = false;
            StringBuffer tmpl = new StringBuffer();
            while ((line = br.readLine()) != null) {
                if (line.equals("<hR><h2>#$#" + name + ";</h2>")) {
                    add = true;
                    continue;
                }
                if (!add) continue;
                if (line.startsWith("<hR>") || line.startsWith("<!-- hR")) break;
                tmpl.append(line).append(NEWLINE);
            }
            br.close();
            if (add) {
                this.templates.setProperty(name, tmpl.toString());
                return tmpl.toString();
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private String htmlescape(String toescape) {
        if (toescape == null) {
            return "";
        }
        while (toescape.startsWith("\n")) {
            toescape = toescape.substring(1);
        }
        while (toescape.endsWith("\n")) {
            toescape = toescape.substring(0, toescape.length() - 1);
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < toescape.length(); ++i) {
            String replacement;
            switch (toescape.charAt(i)) {
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '\n': {
                    replacement = "<br />";
                    break;
                }
                default: {
                    replacement = "" + toescape.charAt(i);
                }
            }
            b.append(replacement);
        }
        return b.toString();
    }
}

