/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.addon.LoadStatus;
import fiw.addon.MetaDataBrowser;
import fiw.core.FIWSystem;
import fiw.core.FileUtil;
import fiw.core.MyLogger;
import fiw.core.NimChecker;
import fiw.core.Settings;
import fiw.core.insert.InsertEngine;
import fiw.core.insert.InsertLogger;
import fiw.core.insert.event.InsertListener;
import fiw.core.insert.event.InsertLoggerListener;
import fiw.fcp.FCPConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;

public class GUIHelper {
    public static GUIHelper instance;
    private final DateFormat DF = new SimpleDateFormat("EEEE, yyyy-MM-dd HH:mm:ss");
    private volatile boolean runningTest = false;
    static /* synthetic */ Class class$fiw$core$GUIHelper;

    private GUIHelper() {
        this.DF.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public static synchronized GUIHelper getInstance() {
        if (instance == null) {
            instance = new GUIHelper();
        }
        return instance;
    }

    public String getRollovers(long increment, long offset) {
        StringBuffer sb = new StringBuffer("Current Settings:\n\nDateRedirect.Increment: " + increment + " = 0x" + Long.toHexString(increment) + "\n" + "DateRedirect.Offset: " + offset + " = 0x" + Long.toHexString(offset) + "\n\n" + "Rollovers:\n\n");
        long timetemp = System.currentTimeMillis() - (offset *= 1000L);
        timetemp = timetemp / (increment *= 1000L) * increment + offset;
        sb.append(this.getDateString(timetemp - increment)).append("\n");
        sb.append(this.getDateString(timetemp)).append("\n");
        sb.append("(Now: ").append(this.DF.format(new Date())).append(" GMT)\n");
        sb.append(this.getDateString(timetemp += increment)).append("\n");
        sb.append(this.getDateString(timetemp += increment)).append("\n");
        return sb.toString();
    }

    public String getDateString(long date) {
        return this.DF.format(new Date(date)) + " GMT";
    }

    public void deleteProject(int projectnum) {
        Settings ss = FIWSystem.getInstance().getSettings();
        ss.deleteProperties("proj." + projectnum + ".");
        for (int i = projectnum; i < ss.getProjCount(); ++i) {
            ss.renameProperties("proj." + (i + 1) + ".", "proj." + i + ".");
        }
        ss.setProperty("proj.count", "" + (ss.getProjCount() - 1));
    }

    public String getBriefProjectInfo(int projectnum) {
        Settings ss = FIWSystem.getInstance().getSettings();
        return "Project name: " + ss.getProjectSetting(projectnum, "name") + "\n\npublic key: " + ss.getProjectSetting(projectnum, "pubkey") + "\nprivate key: " + ss.getProjectSetting(projectnum, "privkey");
    }

    public void testSettings(final int projectnum, final MyLogger ml) {
        if (this.runningTest) {
            return;
        }
        this.runningTest = true;
        new Thread(new Runnable(){

            public void run() {
                FIWSystem.getInstance().getSettings().doTest(FIWSystem.getInstance().getFCPConnection(), projectnum, ml);
                ml.addlog("\n*** End of Test ***");
                GUIHelper.this.runningTest = false;
            }
        }).start();
    }

    public boolean isTestRunning() {
        return this.runningTest;
    }

    public String getDefaultNIM(int projectnum) {
        if (projectnum != -1) {
            String nimname;
            String prefix = "SSK@" + FIWSystem.setts().getProjectSetting(projectnum, "privkey") + FIWSystem.setts().getMaybeEntropy(projectnum) + "/";
            if (prefix.length() < 10) {
                prefix = "KSK@";
            }
            if ((nimname = FIWSystem.setts().getProjectSettingDef(projectnum, "nimprefix", "")) != null && !nimname.equals("")) {
                prefix = prefix + nimname + "-";
            }
            return prefix;
        }
        return "KSK@";
    }

    public boolean handleNIMInsert(String text, int htlvalue, boolean adv, String key, boolean contents, boolean name, boolean redirect, boolean rawMetadata, String ctype, InsertListener listener) {
        if (text.length() == 0) {
            return false;
        }
        if (htlvalue < 0) {
            return false;
        }
        if (adv) {
            int p = key.lastIndexOf("-");
            if (p == -1) {
                return false;
            }
            key = key.substring(p + 1);
            try {
                Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (contents) {
            String filename = "nim-" + FileUtil.dateString() + ".log";
            FileUtil.saveFile(new File(filename), text);
            new InsertEngine(FIWSystem.getInstance().getFCPConnection(), htlvalue, adv, key, ctype, new File(filename), listener);
            return true;
        }
        if (name) {
            File fl = new File(text);
            if (!fl.exists() || fl.isDirectory()) {
                return false;
            }
            new InsertEngine(FIWSystem.getInstance().getFCPConnection(), htlvalue, adv, key, ctype, fl, listener);
            return true;
        }
        if (redirect) {
            String metadata = "Version\nRevision=1\nEndPart\nDocument\nRedirect.Target=freenet:" + text + "\nInfo.Format=" + ctype + "\nEnd\n";
            new InsertEngine(FIWSystem.getInstance().getFCPConnection(), htlvalue, adv, key, metadata, listener);
            return true;
        }
        if (rawMetadata) {
            new InsertEngine(FIWSystem.getInstance().getFCPConnection(), htlvalue, adv, key, text, listener);
            return true;
        }
        return false;
    }

    public boolean moveProjectUp(int projectnum) {
        if (projectnum > 0) {
            FIWSystem.setts().renameProperties("proj." + projectnum + ".", "proj.TEMP.");
            FIWSystem.setts().renameProperties("proj." + (projectnum - 1) + ".", "proj." + projectnum + ".");
            FIWSystem.setts().renameProperties("proj.TEMP.", "proj." + (projectnum - 1) + ".");
            return true;
        }
        return false;
    }

    public boolean moveProjectDown(int projectnum) {
        Settings ss = FIWSystem.getInstance().getSettings();
        if (projectnum < ss.getProjCount() - 1) {
            ss.renameProperties("proj." + projectnum + ".", "proj.TEMP.");
            ss.renameProperties("proj." + (projectnum + 1) + ".", "proj." + projectnum + ".");
            ss.renameProperties("proj.TEMP.", "proj." + (projectnum + 1) + ".");
            return true;
        }
        return false;
    }

    public int cloneProject(int projectnum) {
        Settings ss = FIWSystem.getInstance().getSettings();
        int newnum = ss.getProjCount();
        ss.setProjCount(newnum + 1);
        ss.copyProperties("proj." + projectnum + ".", "proj." + newnum + ".", false);
        return newnum;
    }

    public void openLoadStatus() {
        FCPConnection fc = FIWSystem.getInstance().getFCPConnection();
        new LoadStatus(fc, false);
    }

    public void openMetadataBrowser() {
        FCPConnection fc = FIWSystem.getInstance().getFCPConnection();
        new MetaDataBrowser(fc, false);
    }

    public String handshake(String host, int port) {
        FCPConnection fc = FIWSystem.getInstance().createFCPConnection(host, port);
        return fc.handshake();
    }

    public void startNimChecker(InsertLogger dialog, int htl, int adv) {
        this.startNimChecker(new InsertLoggerListener(dialog), htl, adv);
    }

    public void startNimChecker(InsertListener listener, int htl, int adv) {
        new NimChecker(FIWSystem.getInstance().getFCPConnection(), listener, htl, adv);
    }

    public long getNextSlot(long increment, long offset) {
        return (System.currentTimeMillis() / 1000L - offset) / increment * increment + offset + increment;
    }

    public String[] getAvailableLanguages() {
        Properties prop = new Properties();
        try {
            InputStream in = (class$fiw$core$GUIHelper == null ? (class$fiw$core$GUIHelper = GUIHelper.class$("fiw.core.GUIHelper")) : class$fiw$core$GUIHelper).getResourceAsStream("/res/languages.dat");
            prop.load(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add("Default []");
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String locale = (String)it.next();
            String desc = prop.getProperty(locale);
            res.add(desc + " [" + locale + "]");
        }
        return res.toArray(new String[res.size()]);
    }

    public String getCurrentLanguage() {
        String locale = FIWSystem.getInstance().getSettings().getProperty("locale");
        return locale == null ? "" : locale;
    }

    public void setLanguage(String lang) {
        int pos = lang.indexOf(" [");
        if (pos == -1) {
            throw new IllegalArgumentException("No language");
        }
        String locale = lang.substring(pos + 2, lang.length() - 1);
        FIWSystem.getInstance().setLanguage(locale);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

