/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.FIWSystem;
import fiw.core.I18n;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class FileUtil {
    static /* synthetic */ Class class$fiw$core$Settings;

    public static File fiwDir(File parent) {
        File res = new File(parent, ".fiw");
        File resOld = new File(parent, "__fiw");
        if (resOld.exists()) {
            resOld.renameTo(res);
        }
        if (!res.exists()) {
            res.mkdir();
        }
        return res;
    }

    public static Properties loadMapFile(File dir) {
        Properties p = new Properties();
        if (!FileUtil.loadProperties(p, new File(FileUtil.fiwDir(dir), "mapfile.ini"))) {
            return null;
        }
        return p;
    }

    public static String getWizardDesc(int no) {
        InputStream is = (class$fiw$core$Settings == null ? (class$fiw$core$Settings = FileUtil.class$("fiw.core.Settings")) : class$fiw$core$Settings).getResourceAsStream("/res/" + I18n.get("HelpPrefix") + "-" + no + ".txt");
        if (is == null) {
            return "[Description not found]";
        }
        return FileUtil.loadFileFromStream(is);
    }

    public static String loadFileFromStream(InputStream is) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer s = new StringBuffer();
            while ((line = br.readLine()) != null) {
                s.append(line).append("\n");
            }
            br.close();
            return s.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void saveFile(File fl, String s) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(fl));
            bw.write(s);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String loadFile(File fl) {
        try {
            return FileUtil.loadFileFromStream(new FileInputStream(fl));
        }
        catch (FileNotFoundException e) {
            return "";
        }
    }

    public static boolean loadProperties(Properties p, File f) {
        try {
            FileInputStream in = new FileInputStream(f);
            p.load(in);
            ((InputStream)in).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return false;
        }
    }

    public static boolean saveProperties(Properties p, File f, String desc) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            p.store(out, desc);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            e.printStackTrace(FIWSystem.log());
            return false;
        }
    }

    public static String dateString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return df.format(new Date());
    }

    public static String dateString2() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

