/*
 * Decompiled with CFR 0.152.
 */
package fiw.core;

import fiw.core.I18n;
import fiw.core.Settings;
import fiw.fcp.FCPConn;
import fiw.fcp.FCPConnection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class FIWSystem {
    public static FIWSystem instance;
    public static final boolean doFullLog = false;
    private FCPConnection fcpConn = null;
    private Settings settings = null;
    private I18n i18n = null;
    private PrintStream log = null;
    private PrintStream fullLog = null;

    private FIWSystem() {
    }

    public static synchronized FIWSystem getInstance() {
        if (instance == null) {
            instance = new FIWSystem();
        }
        return instance;
    }

    protected synchronized void setFCPConnection(FCPConnection fcpconn) {
        this.fcpConn = fcpconn;
    }

    public synchronized FCPConnection createFCPConnection(String host, int port) {
        this.fcpConn = FCPConn.fcpFactory(host, port);
        return this.fcpConn;
    }

    public synchronized FCPConnection createFCPConnection() {
        return this.createFCPConnection(this.getSettings().getProperty("fcp.host"), Integer.parseInt(this.getSettings().getProperty("fcp.port")));
    }

    public synchronized FCPConnection getFCPConnection() {
        if (this.fcpConn == null) {
            System.out.println("Warning: Creating FCP connection!");
            return this.createFCPConnection();
        }
        return this.fcpConn;
    }

    public synchronized Settings getSettings() {
        if (this.settings == null) {
            this.settings = Settings.getInstance();
        }
        return this.settings;
    }

    public synchronized I18n getI18n() {
        if (this.i18n == null) {
            String locale = this.getSettings().getProperty("locale");
            this.i18n = locale == null || locale.equals("") ? new I18n() : new I18n(locale);
        }
        return this.i18n;
    }

    public synchronized void setLanguage(String locale) {
        this.getSettings().setProperty("locale", locale);
        this.i18n = null;
    }

    public synchronized PrintStream getLog() {
        this.initLogs();
        return this.log;
    }

    public synchronized PrintStream getFullLog() {
        this.initLogs();
        return this.fullLog;
    }

    private void initLogs() {
        if (this.log == null) {
            try {
                this.log = new PrintStream(new FileOutputStream("logfile.log", true), true);
                this.log.println("SESSION: " + new Date());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static PrintStream log() {
        return FIWSystem.getInstance().getLog();
    }

    public static Settings setts() {
        return FIWSystem.getInstance().getSettings();
    }
}

